package cc.jinglupeng.wechat.bean.message.send;

import net.sf.json.JSONObject;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/**
 * 视频消息
 * 
 * @author jinglupeng.cc
 */
public class Video implements CustomMessage, PassiveMessage {

	private static final long serialVersionUID = 1L;
	private final String msgType = "video";

	private String media_id; // 发送的视频的媒体ID
	private String thumb_media_id; // 缩略图的媒体ID
	private String title; // 视频消息的标题
	private String description; // 视频消息的描述

	public Video() {
	}

	public Video(String media_id, String thumb_media_id, String title,
			String description) {
		this.media_id = media_id;
		this.thumb_media_id = thumb_media_id;
		this.title = title;
		this.description = description;
	}

	public String getMedia_id() {
		return media_id;
	}

	public void setMedia_id(String media_id) {
		this.media_id = media_id;
	}

	public String getThumb_media_id() {
		return thumb_media_id;
	}

	public void setThumb_media_id(String thumb_media_id) {
		this.thumb_media_id = thumb_media_id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Override
	public String toXML(String toUserName, String fromUserName, int createTime) {
		Element root = DocumentHelper.createElement("xml");
		root.addElement("ToUserName").addCDATA(toUserName);
		root.addElement("FromUserName").addCDATA(fromUserName);
		root.addElement("CreateTime").addCDATA(createTime + "");
		root.addElement("MsgType").addCDATA(msgType);
		Element video = root.addElement("Video");
		video.addElement("MediaId").addCDATA(getMedia_id());
		video.addElement("Title").addCDATA(getTitle());
		video.addElement("Description").addCDATA(getDescription());
		return root.asXML();
	}

	@Override
	public String toJSON(String touser) {
		JSONObject json = new JSONObject();
		json.put("touser", touser);
		json.put("msgtype", msgType);
		JSONObject json1 = new JSONObject();
		json1.put("media_id", getMedia_id());
		json1.put("thumb_media_id", getThumb_media_id());
		json1.put("title", getTitle());
		json1.put("description", getDescription());
		json.put("video", json1);
		return json.toString();
	}

}
