package cc.jinglupeng.wechat.bean.message.send;

import net.sf.json.JSONObject;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/**
 * 音乐消息
 * 
 * @author jinglupeng.cc
 */
public class Music implements CustomMessage, PassiveMessage {

	private static final long serialVersionUID = 1L;
	private final String msgType = "music";

	private String title; // 音乐标题
	private String description; // 音乐描述
	private String musicurl; // 音乐链接
	private String hqmusicurl; // 高品质音乐链接，WIFI环境优先使用该链接播放音乐
	private String thumb_media_id; // 缩略图的媒体ID

	public Music() {
	}

	public Music(String title, String description, String musicurl,
			String hqmusicurl, String thumb_media_id) {
		this.title = title;
		this.description = description;
		this.musicurl = musicurl;
		this.hqmusicurl = hqmusicurl;
		this.thumb_media_id = thumb_media_id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getMusicurl() {
		return musicurl;
	}

	public void setMusicurl(String musicurl) {
		this.musicurl = musicurl;
	}

	public String getHqmusicurl() {
		return hqmusicurl;
	}

	public void setHqmusicurl(String hqmusicurl) {
		this.hqmusicurl = hqmusicurl;
	}

	public String getThumb_media_id() {
		return thumb_media_id;
	}

	public void setThumb_media_id(String thumb_media_id) {
		this.thumb_media_id = thumb_media_id;
	}

	@Override
	public String toXML(String toUserName, String fromUserName, int createTime) {
		Element root = DocumentHelper.createElement("xml");
		root.addElement("ToUserName").addCDATA(toUserName);
		root.addElement("FromUserName").addCDATA(fromUserName);
		root.addElement("CreateTime").addCDATA(createTime + "");
		root.addElement("MsgType").addCDATA(msgType);
		Element music = root.addElement("Music");
		music.addElement("Title").addCDATA(getTitle());
		music.addElement("Description").addCDATA(getDescription());
		music.addElement("MusicUrl").addCDATA(getMusicurl());
		music.addElement("HQMusicUrl").addCDATA(getHqmusicurl());
		music.addElement("ThumbMediaId").addCDATA(getThumb_media_id());
		return root.asXML();
	}

	@Override
	public String toJSON(String touser) {
		JSONObject json = new JSONObject();
		json.put("touser", touser);
		json.put("msgtype", msgType);
		JSONObject json1 = new JSONObject();
		json1.put("title", getTitle());
		json1.put("description", getDescription());
		json1.put("musicurl", getMusicurl());
		json1.put("hqmusicurl", getHqmusicurl());
		json1.put("thumb_media_id", getThumb_media_id());
		json.put("music", json1);
		return json.toString();
	}

}
