package cc.jinglupeng.wechat.bean.menu;

import java.io.Serializable;

import cc.jinglupeng.wechat.util.JSONUtil;

/**
 * 菜单
 * 
 * @author jinglupeng.cc
 */
public class Menu implements Serializable {

	private static final long serialVersionUID = 1L;

	private String type; // 菜单的响应动作类型
	private String name; // 菜单标题，不超过16个字节，子菜单不超过40个字节
	private String key; // 菜单KEY值，用于消息接口推送，不超过128字节
	private String url; // 网页链接，用户点击菜单可打开链接，不超过256字节
	private Menu[] button; // 一级菜单数组，个数应为1~3个

	private Menu[] sub_button; // 二级菜单数组，个数应为1~5个

	public Menu() {
	}

	public Menu(String name, MenuType type, String keyOrUrl) {
		this.name = name;
		this.type = type.toString();
		if (type == MenuType.view) {
			this.url = keyOrUrl;
		} else {
			this.key = keyOrUrl;
		}
	}

	public Menu(String name, Menu... menus) {
		this.name = name;
		this.sub_button = menus;
	}

	public Menu(Menu... menus) {
		this.button = menus;
	}

	public void setType(String type) {
		this.type = type;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public void setButton(Menu[] button) {
		this.button = button;
	}

	public void setSub_button(Menu[] sub_button) {
		this.sub_button = sub_button;
	}

	public String getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public String getKey() {
		return key;
	}

	public String getUrl() {
		return url;
	}

	public Menu[] getSub_button() {
		return sub_button;
	}

	public Menu[] getButton() {
		return button;
	}

	@Override
	public String toString() {
		return JSONUtil.serialize(this);
	}

}
