package cc.jinglupeng.wechat.bean;

import java.io.Serializable;

/**
 * 抽象微信错误码，建议所有响应Bean继承该类
 * 
 * @author jinglupeng.cc
 */
public class Status implements Serializable {

	private static final long serialVersionUID = 1L;

	private Integer errcode;
	private String errmsg;

	public Status() {
		this.errcode = 0;
		this.errmsg = "";
	}

	public Status(Integer errcode, String errmsg) {
		this.errcode = errcode;
		this.errmsg = errmsg;
	}

	public void setError(Integer errcode, String errmsg) {
		this.errcode = errcode;
		this.errmsg = errmsg;

	}

	public boolean isSuccess() {
		return "0".equals("" + this.errcode);
	}

	public Integer getErrcode() {
		return errcode;
	}

	public void setErrcode(Integer errcode) {
		this.errcode = errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public void setErrmsg(String errmsg) {
		this.errmsg = errmsg;
	}
}
