package cc.jinglupeng.wechat;

import java.util.HashMap;
import java.util.Map;

import cc.jinglupeng.wechat.bean.Account;

/**
 * 公众号资料缓存
 * 
 * @author jinglupeng.cc
 */
public class AccountCache {

	private static final Map<String, Account> cache = new HashMap<String, Account>();

	public synchronized static Account get(String appId) {
		return cache.get(appId);
	}

	public synchronized static void put(Account account) {
		String appId = account.getAppId();
		cache.put(appId, account);
	}

}
