package cc.jinglupeng.wechat;

import java.util.HashMap;
import java.util.Map;

import cc.jinglupeng.wechat.bean.AccessToken;

/**
 * AccessToken 缓存
 * 
 * @author jinglupeng.cc
 */
public class AccessTokenCache {

	private static final Map<String, AccessToken> cache = new HashMap<String, AccessToken>();

	public synchronized static AccessToken get(String appId) {
		AccessToken token = cache.get(appId);
		if (token == null)
			return null;
		Long now = System.currentTimeMillis();
		Long old = token.getCreateTime();
		if (now - old > 6000 * 1000) {
			return null;
		}
		return token;
	}

	public synchronized static void put(String appId, AccessToken accessToken) {
		cache.put(appId, accessToken);
	}

}
