package cc.javaone.jpa.domain;

import java.util.Objects;

/**
 * @author jy
 * @date 2018/03/24
 */
@SuppressWarnings("unchecked")
public interface BaseEnum<E extends Enum<E>, K> {

    static <E extends Enum<E>, K> E of(BaseEnum[] all, K k) {
        for (BaseEnum baseEnum : all) {
            if (Objects.equals(baseEnum.getValue(), k)) {
                return (E) baseEnum;
            }
        }
        return null;
    }

    K getValue();

    default E of(K k) {
        BaseEnum[] enumConstants = getClass().getEnumConstants();
        for (BaseEnum enumConstant : enumConstants) {
            if (Objects.equals(enumConstant.getValue(), k)) {
                return (E) enumConstant;
            }
        }
        return null;
    }

}
