package cc.javaone.jpa.converter;

import cc.javaone.jpa.domain.BaseEnum;

import javax.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;

public abstract class AbstractConverter<E extends BaseEnum<? extends Enum, K>, K> implements AttributeConverter<E, K> {
    @Override
    public K convertToDatabaseColumn(E attribute) {
        return attribute.getValue();
    }

    @Override
    @SuppressWarnings("unchecked")
    public E convertToEntityAttribute(K dbData) {
        ParameterizedType parameterizedType = (ParameterizedType) getClass().getGenericSuperclass();
        Class<E> eClass = (Class<E>) parameterizedType.getActualTypeArguments()[0];

        E[] enumConstants = eClass.getEnumConstants();
        return (E) BaseEnum.of(enumConstants, dbData);
    }
}