/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.sqltable;

import cc.iliz.mybatis.shading.db.ShardingEntry;
import cc.iliz.mybatis.shading.sqltable.BaseSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.DeleteSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.InsertSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.SelectSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.SqlTableParser;
import cc.iliz.mybatis.shading.sqltable.UpdateSqlTableParser;
import java.util.Locale;
import org.apache.ibatis.mapping.SqlCommandType;

public class RouteSqlTableParser
implements SqlTableParser {
    private BaseSqlTableParser sqlTableParser;

    @Override
    public ShardingEntry markShardingTable(String sql, Object param) {
        SqlCommandType commandType = this.getSqlCommandType(sql);
        switch (commandType) {
            case SELECT: {
                this.sqlTableParser = new SelectSqlTableParser();
                break;
            }
            case UPDATE: {
                this.sqlTableParser = new UpdateSqlTableParser();
                break;
            }
            case DELETE: {
                this.sqlTableParser = new DeleteSqlTableParser();
                break;
            }
            case INSERT: {
                this.sqlTableParser = new InsertSqlTableParser();
                break;
            }
        }
        if (this.sqlTableParser != null) {
            return this.sqlTableParser.markShardingTable(sql, param);
        }
        return null;
    }

    private SqlCommandType getSqlCommandType(String sql) {
        String usql = sql.trim().toUpperCase(Locale.ENGLISH);
        if (usql.startsWith("SELECT")) {
            return SqlCommandType.SELECT;
        }
        if (usql.startsWith("UPDATE")) {
            return SqlCommandType.UPDATE;
        }
        if (usql.startsWith("DELETE")) {
            return SqlCommandType.DELETE;
        }
        if (usql.startsWith("INSERT")) {
            return SqlCommandType.INSERT;
        }
        return SqlCommandType.UNKNOWN;
    }
}

