/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.sqltable;

import cc.iliz.mybatis.shading.db.ShardingContextHolder;
import cc.iliz.mybatis.shading.db.ShardingEntry;
import cc.iliz.mybatis.shading.db.ShardingProxyDataSource;
import cc.iliz.mybatis.shading.exception.ShardingException;
import cc.iliz.mybatis.shading.sqltable.SqlTableParser;
import cc.iliz.mybatis.shading.strategy.StrategyRegister;
import cc.iliz.mybatis.shading.strategy.TableStrategy;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class BaseSqlTableParser
implements SqlTableParser {
    private static final Log log = LogFactory.getLog(BaseSqlTableParser.class);

    @Override
    public ShardingEntry markShardingTable(String sql, Object param) {
        Pattern pattern = this.getRegPattern();
        Matcher matcher = pattern.matcher(sql);
        ShardingEntry entry = null;
        try {
            entry = this.sqlConvert(matcher, param);
        }
        catch (ShardingException e) {
            log.error("\u975e\u540c\u4e00\u5e93\u4ee5\u53ca\u672a\u627e\u5230\u6570\u636e\u6e90\u5f02\u5e38,sql\u662f: " + sql);
        }
        return entry;
    }

    public abstract Pattern getRegPattern();

    protected ShardingEntry sqlConvert(Matcher matcher, Object param) throws ShardingException {
        ShardingEntry entry = new ShardingEntry();
        StringBuffer sb = new StringBuffer();
        ShardingProxyDataSource ds = null;
        while (matcher.find()) {
            String g0 = matcher.group();
            String tableName = matcher.group(1);
            if (StringUtils.hasText((String)tableName)) {
                String newTableName = this.tableNameConvert(this.getRealTableName(tableName).trim(), param);
                if (ds == null) {
                    ds = this.isSameDatabase(newTableName, null);
                } else {
                    ShardingProxyDataSource tds = this.isSameDatabase(newTableName, ds);
                    if (ds != tds) {
                        throw new ShardingException("");
                    }
                    ds = tds;
                }
                if (log.isDebugEnabled()) {
                    log.debug("get real table name is [" + newTableName + "]");
                }
                g0 = g0.replaceAll(tableName, newTableName);
            }
            matcher.appendReplacement(sb, g0);
        }
        matcher.appendTail(sb);
        if (ds == null) {
            throw new ShardingException("");
        }
        entry.setProxy(ds);
        entry.setSql(sb.toString());
        return entry;
    }

    private ShardingProxyDataSource isSameDatabase(String newTableName, ShardingProxyDataSource datasource) {
        if (datasource != null) {
            for (String name : datasource.getTableNames()) {
                if (!name.trim().equalsIgnoreCase(newTableName)) continue;
                return datasource;
            }
        }
        Set<ShardingProxyDataSource> set = ShardingContextHolder.getShardingProxyDataSource();
        for (ShardingProxyDataSource s : set) {
            for (String name : s.getTableNames()) {
                if (!name.trim().equalsIgnoreCase(newTableName)) continue;
                return s;
            }
        }
        return null;
    }

    protected String tableNameConvert(String tableName, Object param) {
        TableStrategy strategy = StrategyRegister.getInstance().getTableStrategy(tableName);
        if (strategy != null) {
            return strategy.getShadeTableName(this, tableName, param);
        }
        return tableName;
    }

    protected String getRealTableName(String tableName) {
        return tableName.toLowerCase();
    }
}

