/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ShardingProxyDataSource
implements DataSource,
Comparable<ShardingProxyDataSource> {
    private static final Log log = LogFactory.getLog(ShardingProxyDataSource.class);
    private DataSource dataSource;
    private Set<String> tableNames;
    private Integer order = 1;

    public static ShardingProxyDataSource instanceBuilder(DataSource dataSource, Integer order) {
        ShardingProxyDataSource instance = new ShardingProxyDataSource();
        instance.setDataSource(dataSource);
        instance.setOrder(order);
        return instance;
    }

    public boolean checkDataSourceByTableName(String name) {
        return this.tableNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanDatasourceScheme() {
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            rs = meta.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
            HashSet<String> sets = new HashSet<String>();
            while (rs.next()) {
                sets.add(rs.getString(3));
            }
            this.tableNames = sets;
        }
        catch (SQLException e) {
            log.error("\u626b\u63cf\u6570\u636e\u6e90\u5143\u6570\u636e\u5f02\u5e38");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.scanDatasourceScheme();
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Set<String> getTableNames() {
        return this.tableNames;
    }

    public Integer getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(ShardingProxyDataSource o) {
        return o.getOrder().compareTo(this.getOrder());
    }
}

