/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.strategy;

import cc.iliz.mybatis.shading.annotation.Strategy;
import cc.iliz.mybatis.shading.strategy.TableStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class StrategyRegister {
    private static final Log log = LogFactory.getLog(StrategyRegister.class);
    private Map<String, TableStrategy> register = new ConcurrentHashMap<String, TableStrategy>();
    private static StrategyRegister instance = new StrategyRegister();

    private StrategyRegister() {
    }

    public static StrategyRegister getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String tableName, TableStrategy tableStrategy) {
        Strategy strategy = tableStrategy.getClass().getDeclaredAnnotation(Strategy.class);
        Map<String, TableStrategy> map = this.register;
        synchronized (map) {
            if (strategy != null) {
                this.register.put(strategy.tableName().toLowerCase(), tableStrategy);
                if (log.isDebugEnabled()) {
                    log.debug("Table name [" + strategy.tableName().toLowerCase() + "] registe sharding strategy [" + tableStrategy.getClass().getName() + "] success");
                }
            } else {
                this.register.put(tableName.toLowerCase(), tableStrategy);
                if (log.isDebugEnabled()) {
                    log.debug("Table name [" + tableName.toLowerCase() + "] registe sharding strategy [" + tableStrategy.getClass().getName() + "] success");
                }
            }
        }
    }

    public void register(String tableName, Class<?> clazz) {
        try {
            Object obj = clazz.newInstance();
            if (obj instanceof TableStrategy) {
                TableStrategy tableStrategy = (TableStrategy)obj;
                this.register(tableName, tableStrategy);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void register(Class<?> clazz) {
        Strategy strategy = clazz.getDeclaredAnnotation(Strategy.class);
        if (strategy != null) {
            this.register(strategy.tableName(), clazz);
        }
    }

    public void register(TableStrategy tableStrategy) {
        Strategy strategy = tableStrategy.getClass().getDeclaredAnnotation(Strategy.class);
        if (strategy != null) {
            this.register(strategy.tableName(), tableStrategy);
        }
    }

    public void register(String tableName, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            this.register(tableName, clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public TableStrategy getTableStrategy(String tableName) {
        return this.register.get(tableName);
    }
}

