/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.sqltable;

import cc.iliz.mybatis.shading.sqltable.SqlTableParser;
import cc.iliz.mybatis.shading.strategy.StrategyRegister;
import cc.iliz.mybatis.shading.strategy.TableStrategy;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.ParameterMapping;

public abstract class BaseSqlTableParser
implements SqlTableParser {
    private static final Log log = LogFactory.getLog(BaseSqlTableParser.class);

    @Override
    public String markShardingTable(String sql, Object param, List<ParameterMapping> parameterMappings) {
        Pattern pattern = this.getRegPattern();
        Matcher matcher = pattern.matcher(sql);
        sql = this.sqlConvert(matcher, param, parameterMappings);
        return sql;
    }

    public abstract Pattern getRegPattern();

    protected String sqlConvert(Matcher matcher, Object param, List<ParameterMapping> parameterMappings) {
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String g0 = matcher.group();
            String tableName = matcher.group(1);
            String newTableName = this.tableNameConvert(this.getRealTableName(tableName).trim(), param, parameterMappings);
            if (log.isDebugEnabled()) {
                log.debug("get real table name is [" + newTableName + "]");
            }
            g0 = g0.replaceAll(tableName, newTableName);
            matcher.appendReplacement(sb, g0);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String tableNameConvert(String tableName, Object param, List<ParameterMapping> parameterMappings) {
        TableStrategy strategy = StrategyRegister.getInstance().getTableStrategy(tableName);
        if (strategy != null) {
            return strategy.getShadeTableName(this, tableName, param, parameterMappings);
        }
        return tableName;
    }

    protected String getRealTableName(String tableName) {
        return tableName.toLowerCase();
    }
}

