/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.sqltable;

import cc.iliz.mybatis.shading.sqltable.BaseSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.DeleteSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.InsertSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.SelectSqlTableParser;
import cc.iliz.mybatis.shading.sqltable.SqlTableParser;
import cc.iliz.mybatis.shading.sqltable.UpdateSqlTableParser;
import java.util.List;
import java.util.Locale;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;

public class RouteSqlTableParser
implements SqlTableParser {
    @Override
    public String markShardingTable(String sql, Object param, List<ParameterMapping> parameterMappings) {
        SqlCommandType commandType = this.getSqlCommandType(sql);
        BaseSqlTableParser sqlTableParser = null;
        switch (commandType) {
            case SELECT: {
                sqlTableParser = new SelectSqlTableParser();
                break;
            }
            case UPDATE: {
                sqlTableParser = new UpdateSqlTableParser();
                break;
            }
            case DELETE: {
                sqlTableParser = new DeleteSqlTableParser();
                break;
            }
            case INSERT: {
                sqlTableParser = new InsertSqlTableParser();
                break;
            }
        }
        if (sqlTableParser != null) {
            sql = sqlTableParser.markShardingTable(sql, param, parameterMappings);
        }
        return sql;
    }

    private SqlCommandType getSqlCommandType(String sql) {
        String usql = sql.trim().toUpperCase(Locale.ENGLISH);
        if (usql.startsWith("SELECT")) {
            return SqlCommandType.SELECT;
        }
        if (usql.startsWith("UPDATE")) {
            return SqlCommandType.UPDATE;
        }
        if (usql.startsWith("DELETE")) {
            return SqlCommandType.DELETE;
        }
        if (usql.startsWith("INSERT")) {
            return SqlCommandType.INSERT;
        }
        return SqlCommandType.UNKNOWN;
    }
}

