/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.sqltable;

import cc.iliz.mybatis.shading.sqltable.SqlTableParser;
import cc.iliz.mybatis.shading.strategy.StrategyRegister;
import cc.iliz.mybatis.shading.strategy.TableStrategy;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.ParameterMapping;

public abstract class BaseSqlTableParser
implements SqlTableParser {
    private static final Log log = LogFactory.getLog(BaseSqlTableParser.class);

    @Override
    public String markShardingTable(String sql, Object param, List<ParameterMapping> parameterMappings) {
        Pattern pattern = this.getRegPattern();
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            TableStrategy strategy;
            String tableName = matcher.group(1);
            if (tableName == null || tableName.trim() == "") continue;
            String newTableName = this.getRealTableName(tableName);
            if (log.isDebugEnabled()) {
                log.debug("get real table name of  table sharding sql [" + sql + "] is [" + newTableName + "]");
            }
            if ((strategy = StrategyRegister.getInstance().getTableStrategy(newTableName)) == null) continue;
            newTableName = strategy.getShadeTableName(this, tableName, param, parameterMappings);
            sql = sql.replaceAll(tableName, newTableName);
            matcher.reset(sql);
        }
        return sql;
    }

    public abstract Pattern getRegPattern();

    protected String getRealTableName(String tableName) {
        return tableName.toLowerCase();
    }
}

