/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.spring;

import cc.iliz.mybatis.shading.plugin.TableShardPlugin;
import java.io.IOException;
import java.util.Properties;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public class ShardingSqlSessionFactoryBean
extends SqlSessionFactoryBean
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog(ShardingSqlSessionFactoryBean.class);
    private String shardingScanPackage;
    private TableShardPlugin tableShardPlugin = new TableShardPlugin();
    private ApplicationContext applicationContext;

    public String getShardingScanPackage() {
        return this.shardingScanPackage;
    }

    public void setShardingScanPackage(String shardingScanPackage) {
        this.shardingScanPackage = shardingScanPackage;
    }

    public TableShardPlugin getTableShardPlugin() {
        return this.tableShardPlugin;
    }

    public void setTableShardPlugin(TableShardPlugin tableShardPlugin) {
        this.tableShardPlugin = tableShardPlugin;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        SqlSessionFactory sqlSessionFactory = super.buildSqlSessionFactory();
        if (StringUtils.hasText((String)this.shardingScanPackage)) {
            Properties prop = new Properties();
            prop.put("packageNames", this.shardingScanPackage);
            this.tableShardPlugin.setProperties(prop);
            if (log.isDebugEnabled()) {
                log.debug("shardingScanPackage is [" + this.shardingScanPackage + "]");
            }
        }
        this.tableShardPlugin.setApplicationContext(this.applicationContext);
        sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)this.tableShardPlugin);
        return sqlSessionFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

