/*
 * Decompiled with CFR 0.152.
 */
package cc.iliz.mybatis.shading.plugin;

import cc.iliz.mybatis.shading.convert.ConverterFactory;
import cc.iliz.mybatis.shading.convert.ConverterFactoryBuilder;
import cc.iliz.mybatis.shading.parse.XmlConfigParser;
import cc.iliz.mybatis.shading.strategy.StrategyRegister;
import cc.iliz.mybatis.shading.strategy.TableStrategy;
import cc.iliz.mybatis.shading.util.ReflectionUtils;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class TableShardPlugin
implements Interceptor {
    private static final Log log = LogFactory.getLog(TableShardPlugin.class);
    public static final String SHARDING_CONFIG = "shardingConfig";
    public static final String STRATEGY_CONFIG = "packageNames";
    private String scanPackage;
    private static AtomicBoolean parsed = new AtomicBoolean(false);
    private ApplicationContext applicationContext;

    public String getScanPackage() {
        return this.scanPackage;
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof StatementHandler) {
            if (!parsed.get()) {
                this.parseAnnotationAuto();
            }
            StatementHandler handler = (StatementHandler)invocation.getTarget();
            String sql = handler.getBoundSql().getSql();
            if (log.isDebugEnabled()) {
                log.debug("table sharding orginal sql is [" + sql + "]");
            }
            ConverterFactory factory = ConverterFactoryBuilder.getConverterFactoryBuilder().getConverterFacotry();
            sql = factory.getSqlConverter().convert(sql, handler.getBoundSql().getParameterMappings(), handler.getBoundSql().getParameterObject());
            if (log.isDebugEnabled()) {
                log.debug("table sharding converted sql is [" + sql + "]");
            }
            ReflectionUtils.setFieldValue(handler.getBoundSql(), "sql", sql);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        if (parsed.get()) {
            return;
        }
        String config = properties.getProperty(SHARDING_CONFIG, null);
        if (log.isDebugEnabled()) {
            log.debug("sharding config is \uff1a[" + config + "]");
        }
        if (config != null && config.trim().length() > 0) {
            XmlConfigParser parser = new XmlConfigParser(config);
            parser.parse();
        }
        String sconfig = properties.getProperty(STRATEGY_CONFIG, null);
        if (log.isDebugEnabled()) {
            log.debug("strategy scan config is \uff1a[" + sconfig + "]");
        }
        ResolverUtil resolverUtil = new ResolverUtil();
        Set tableStrategys = null;
        if (sconfig != null && sconfig.trim().length() > 0) {
            tableStrategys = resolverUtil.findImplementations(TableStrategy.class, sconfig.split(",")).getClasses();
            StrategyRegister register = StrategyRegister.getInstance();
            tableStrategys.stream().forEach(t -> register.register((Class<?>)t));
        }
        if (log.isDebugEnabled()) {
            log.debug("table strategy config parse success.");
        }
        parsed.set(true);
    }

    private void parseAnnotationAuto() {
        if (this.applicationContext != null) {
            Map strategys = this.applicationContext.getBeansOfType(TableStrategy.class);
            StrategyRegister register = StrategyRegister.getInstance();
            strategys.entrySet().stream().forEach(t -> register.register((TableStrategy)t.getValue()));
        }
        if (StringUtils.hasText((String)this.scanPackage)) {
            ResolverUtil resolverUtil = new ResolverUtil();
            Set tableStrategys = resolverUtil.findImplementations(TableStrategy.class, this.scanPackage.split(",")).getClasses();
            if (log.isDebugEnabled()) {
                log.debug("auto scaned annotation \uff1a[" + this.scanPackage + "], table sharding strategy list is \uff1a" + tableStrategys.toString());
            }
            StrategyRegister register = StrategyRegister.getInstance();
            tableStrategys.stream().forEach(t -> register.register((Class<?>)t));
            parsed.set(true);
            if (log.isDebugEnabled()) {
                log.debug("success scaned annotation automatically\u3002scanned package is \uff1a[" + this.scanPackage + "]");
            }
        }
        parsed.set(true);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

