/*
 * Decompiled with CFR 0.152.
 */
package cc.ikai.caller.utils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisStd;

public class ReflectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);

    public static Object directSetField(Class<?> clazz, Map<String, Object> valuesMap) {
        ObjenesisStd objenesis = new ObjenesisStd();
        Object target = objenesis.newInstance(clazz);
        Field[] fields = clazz.getDeclaredFields();
        Arrays.stream(fields).forEach(field -> {
            field.setAccessible(true);
            String name = field.getName();
            if (valuesMap.containsKey(name)) {
                ReflectionUtils.setFiledValue(field, target, valuesMap.get(name));
            }
        });
        return target;
    }

    private static void setFiledValue(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException("Failed set filed value.");
        }
    }
}

