/*
 * Decompiled with CFR 0.152.
 */
package cc.ikai.caller.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);

    @Nullable
    public static Method parse(String className, String methodName, Map<String, Object> paramsMap) {
        Class clazz = Parser.getClass(className);
        Method[] methods = clazz.getDeclaredMethods();
        return Arrays.stream(methods).filter(m -> StringUtils.equals((CharSequence)methodName, (CharSequence)m.getName())).filter(m -> Parser.isTargetMethod(m, paramsMap)).findFirst().orElse(null);
    }

    private static boolean isTargetMethod(Method m, Map<String, Object> paramsMap) {
        Parameter[] parameters = m.getParameters();
        if (parameters.length != paramsMap.size()) {
            return false;
        }
        Set<String> paramNameSet = paramsMap.keySet();
        return Arrays.stream(parameters).map(Parameter::getName).allMatch(paramNameSet::contains);
    }

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error("", (Throwable)e);
            throw new RuntimeException("Class not found: " + className);
        }
    }
}

