/*
 * Decompiled with CFR 0.152.
 */
package cc.ikai.caller.core;

import cc.ikai.caller.core.BeanContext;
import cc.ikai.caller.utils.Parser;
import cc.ikai.caller.utils.ReflectionUtils;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Caller {
    private final Logger logger = LoggerFactory.getLogger(Caller.class);

    public Object doCall(Map<String, Object> requestMap) {
        String className = MapUtils.getString(requestMap, (Object)"className");
        String methodName = MapUtils.getString(requestMap, (Object)"methodName");
        boolean isDirectSetFiled = Optional.ofNullable(MapUtils.getBoolean(requestMap, (Object)"directSetFiledForObjectParam")).orElse(false);
        Map paramsMap = MapUtils.getMap(requestMap, (Object)"params");
        Method method = Parser.parse(className, methodName, paramsMap);
        if (method == null) {
            return "Call failed: no method find!";
        }
        Object targetBean = BeanContext.get(Parser.getClass(className));
        Parameter[] parameters = method.getParameters();
        ArrayList inputValues = new ArrayList();
        Arrays.stream(parameters).forEach(p -> {
            Object convertValue = this.getConvertedParam((Parameter)p, paramsMap, isDirectSetFiled);
            inputValues.add(convertValue);
        });
        try {
            return method.invoke(targetBean, inputValues.toArray(new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.logger.error("", (Throwable)e);
            return "Call failed: occur error!";
        }
    }

    private Object getConvertedParam(Parameter p, Map<String, Object> paramsMap, boolean isDirectSetField) {
        Object rawValue = paramsMap.get(p.getName());
        if (!(rawValue instanceof Map)) {
            return ConvertUtils.convert((Object)rawValue, p.getType());
        }
        Class<?> paramClass = p.getType();
        if (this.isCollectionParam(paramClass) || !isDirectSetField) {
            return JSON.parseObject((String)JSON.toJSONString((Object)rawValue), p.getType());
        }
        Map localMap = (Map)rawValue;
        return ReflectionUtils.directSetField(paramClass, localMap);
    }

    private boolean isCollectionParam(Class paramClass) {
        return Map.class.isAssignableFrom(paramClass) || Collection.class.isAssignableFrom(paramClass);
    }
}

