/*
 * Decompiled with CFR 0.152.
 */
package cc.heirloom.gradle.cobol;

import cc.heirloom.gradle.cobol.COBOLCompileOptions;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkerExecutor;

public class CompileCOBOLTask
extends AbstractCompile {
    private final ConfigurableFileCollection cobolSourcePath;
    private final WorkerExecutor workerExec;
    private final ExecOperations execOperations;
    private final COBOLCompileOptions COBOLCompileOptions = new COBOLCompileOptions();
    private final CompileOptions compileOptions;

    @Inject
    public CompileCOBOLTask(ObjectFactory objectFactory, WorkerExecutor workerExec, ExecOperations execOperations) {
        CompileOptions compileOptions;
        this.compileOptions = compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        this.execOperations = execOperations;
        this.cobolSourcePath = this.getProject().files(new Object[0]);
        this.workerExec = workerExec;
    }

    @InputFiles
    public ConfigurableFileCollection getCobolSourcePath() {
        return this.cobolSourcePath;
    }

    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    public COBOLCompileOptions getCOBOLOptions() {
        return this.COBOLCompileOptions;
    }

    @TaskAction
    void doCOBOLCompile() {
        String cobolExe = "build\\bin\\win64\\x86_64\\ecobol.exe";
        if (OperatingSystem.current().isWindows()) {
            cobolExe = "build/bin/win64/x86_64/ecobol.exe";
        }
        if (OperatingSystem.current().isLinux()) {
            cobolExe = "build/bin/linux/x86_64/ecobol";
        }
        if (OperatingSystem.current().isMacOsX()) {
            cobolExe = "build/bin/macosx/x86_64/ecobol";
        }
        String finalCobolExe = cobolExe;
        for (File sourceFile : this.getSource().getFiles()) {
            this.getProject().exec(execSpec -> {
                execSpec.executable((Object)finalCobolExe);
                execSpec.args(new Object[]{"-cc"});
                execSpec.args(new Object[]{sourceFile.toString()});
                execSpec.args(new Object[]{"-out:dir"});
                execSpec.args(new Object[]{this.getProject().getBuildDir() + "/generated/src/main/intermediate_java"});
                execSpec.args(new Object[]{"-out:ecoboldir"});
                execSpec.args(new Object[]{this.getProject().getRootDir() + "/resources/"});
            }).assertNormalExitValue();
        }
    }
}

