/*
 * Decompiled with CFR 0.152.
 */
package cc.heirloom.gradle.cobol;

import cc.heirloom.gradle.cobol.COBOLSourceSet;
import cc.heirloom.gradle.cobol.CompileCOBOLTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;

public class COBOLPlugin
implements Plugin<Project> {
    static final String LANG_NAME = "COBOL";

    public void apply(Project project) {
        project.getPluginManager().apply("java");
        this.addIntermediateJavaSource(project);
        this.createSourceSetDefaults(project);
        this.addJavaDependsOnCOBOL(project);
        this.downloadcobolcompiler(project);
    }

    private void downloadcobolcompiler(Project project) {
        Configuration config = null;
        try {
            config = project.getConfigurations().getByName("HCIDownload");
        }
        catch (UnknownConfigurationException ex) {
            System.out.println("warning no HCIDownload configuration found defaulting to standard Heirloom Maven Repository");
        }
        if (config == null) {
            config = (Configuration)project.getConfigurations().create("HCIDownload");
            project.getDependencies().add(config.getName(), (Object)"cc.heirloom.hci:publish_artifacts:0.2@zip");
        }
        config.setTransitive(false);
        Configuration finalConfig = config.copy();
        project.copy(copySpec -> {
            copySpec.setFileMode(Integer.valueOf(493));
            copySpec.from(new Object[]{project.zipTree((Object)finalConfig.getSingleFile())});
            copySpec.into((Object)project.getBuildDir());
        });
    }

    private void addJavaDependsOnCOBOL(Project project) {
        Task javaCompile = (Task)project.getTasks().findByName("compileJava");
        assert (javaCompile != null);
        Task cobolCompile = (Task)project.getTasks().findByName("compileCOBOL");
        javaCompile.dependsOn(new Object[]{cobolCompile});
    }

    private void addIntermediateJavaSource(Project project) {
        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSetContainer sourceSets = javaPlugin.getSourceSets();
        SourceSet main = (SourceSet)javaPlugin.getSourceSets().findByName("main");
        main.getJava().srcDir((Object)new File(project.getBuildDir() + "/generated/src/main/intermediate_java"));
    }

    private void createSourceSetDefaults(final Project project) {
        ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(final SourceSet sourceSet) {
                final COBOLSourceSet COBOLDefaultSourceSet = new COBOLSourceSet(COBOLPlugin.LANG_NAME, project.getObjects());
                new DslObject((Object)sourceSet).getConvention().getPlugins().put(COBOLPlugin.LANG_NAME, COBOLDefaultSourceSet);
                COBOLDefaultSourceSet.getCOBOL().srcDir((Object)("src/" + sourceSet.getName() + "/COBOL"));
                sourceSet.getResources().getFilter().exclude((Spec)new Spec<FileTreeElement>(){

                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return COBOLDefaultSourceSet.getCOBOL().contains(element.getFile());
                    }
                });
                sourceSet.getAllJava().source(COBOLDefaultSourceSet.getCOBOL());
                sourceSet.getAllSource().source(COBOLDefaultSourceSet.getCOBOL());
                TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName(COBOLPlugin.LANG_NAME), CompileCOBOLTask.class, (Action)new Action<CompileCOBOLTask>(){

                    public void execute(CompileCOBOLTask compile) {
                        compile.setDescription("Compiles the " + sourceSet.getName() + " COBOL source.");
                        compile.setSource((FileTree)COBOLDefaultSourceSet.getCOBOL());
                        ConfigurableFileCollection classpath = project.files(new Object[]{new File("ddd"), new File("ddda")});
                        compile.setClasspath((FileCollection)classpath);
                        compile.setDestinationDir(new File(project.getBuildDir() + "/generated/src/main/intermediate_java"));
                    }
                });
                JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)COBOLDefaultSourceSet.getCOBOL(), (Project)project, (Provider)compileTask, (Provider)compileTask.map(COBOLCompile -> COBOLCompile.getOptions()));
            }
        });
    }
}

