package cc.heirloom.gradle.cobol;

import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.archive.ZipFileTree;
import org.gradle.api.model.ObjectFactory;

import org.gradle.api.tasks.*;
import org.gradle.api.file.DirectoryProperty;

import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;

import org.gradle.process.ExecSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;


import javax.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;


public class CompileCOBOLTask extends AbstractCompile {

    private final ConfigurableFileCollection cobolSourcePath;
    //private final DirectoryProperty destinationDirectory;
    private final WorkerExecutor workerExec;
    private final ExecOperations execOperations;
    private final COBOLCompileOptions COBOLCompileOptions;
    private final CompileOptions compileOptions;
    @Inject
    public  CompileCOBOLTask(ObjectFactory objectFactory, WorkerExecutor workerExec, ExecOperations execOperations) {
        super();
        COBOLCompileOptions = new COBOLCompileOptions();
        CompileOptions compileOptions = objectFactory.newInstance(CompileOptions.class);
        this.compileOptions = compileOptions;
        this.execOperations = execOperations;
        this.cobolSourcePath = getProject().files();
       // this.destinationDirectory = objectFactory.directoryProperty();
        this.workerExec = workerExec;

    }

    @InputFiles
    public ConfigurableFileCollection getCobolSourcePath() {
        return cobolSourcePath;
    }

//    @OutputDirectory
//    public DirectoryProperty getDestinationDirectory() {
//        return destinationDirectory;
//    }

    public CompileOptions getOptions() { return compileOptions; }
    public COBOLCompileOptions getCOBOLOptions() { return COBOLCompileOptions; }

    @TaskAction
    void doCOBOLCompile() {


        //File COBOLExe = OperatingSystem.current().findInPath("ecobol.exe");

        String cobolExe = "build\\bin\\win64\\x86_64\\ecobol.exe";
        if (OperatingSystem.current().isWindows()) cobolExe = "build/bin/win64/x86_64/ecobol.exe";
        if (OperatingSystem.current().isLinux()) cobolExe = "build/bin/linux/x86_64/ecobol";
        if (OperatingSystem.current().isMacOsX()) cobolExe = "build/bin/macosx/x86_64/ecobol";

        String finalCobolExe = cobolExe;

        for (File sourceFile : getSource().getFiles()) {
            getProject().exec(execSpec -> {
                execSpec.executable(finalCobolExe);
                execSpec.args("-cc");
                execSpec.args(sourceFile.toString());
                execSpec.args("-out:dir");
                execSpec.args(getProject().getBuildDir() + "/generated/src/main/intermediate_java") ; //TODO should get from the sourceset/task config
                execSpec.args("-out:ecoboldir");
                execSpec.args(getProject().getRootDir() + "/resources/"); //TODO should get from the sourceset/task config
//                execSpec.args("-source:copypath");
//                execSpec.args(getProject().getRootDir() + "/copylib"); //TODO should get from the sourceset/task config

            }
            ).assertNormalExitValue();
        }
    }

}