package cc.heirloom.gradle.cobol;

import groovy.lang.Closure;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.util.ConfigureUtil;

public class COBOLSourceSet {
    static final String LANG_NAME = "COBOL";

    COBOLSourceSet(String displayName, ObjectFactory objectFactory) {
        COBOLOnlySourceSet = objectFactory.sourceDirectorySet(displayName, displayName +  " COBOL source");
        COBOLOnlySourceSet.getFilter().include("**/*.cbl", "**/*.cob");

    }

    COBOLSourceSet COBOL(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, getCOBOL());
        return this;
    }

    public SourceDirectorySet getCOBOL() { return COBOLOnlySourceSet; }

    private final SourceDirectorySet COBOLOnlySourceSet;
}
