package cc.heirloom.gradle.cobol;

import groovy.lang.Closure;
import org.gradle.api.*;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import java.io.File;

public class COBOLPlugin implements Plugin<Project> {
    static final String LANG_NAME = COBOLSourceSet.LANG_NAME;

    public void apply(Project project) {
        project.getPluginManager().apply("java");

        addIntermediateJavaSource(project);
        createSourceSetDefaults(project);
        addJavaDependsOnCOBOL(project);

        downloadcobolcompiler(project);


    }

    private void downloadcobolcompiler(Project project) {

        Configuration config = null;
        try {
            config = project.getConfigurations().getByName("HCIDownload");
        }
        catch (UnknownConfigurationException ex) {
            System.out.println("warning no HCIDownload configuration found defaulting to standard Heirloom Maven Repository");
        }
        if (config == null) {  //ie none was specified in the buildscript then download a known version
            config =  project.getConfigurations().create("HCIDownload");
            project.getDependencies().add(config.getName(), "cc.heirloom.hci:publish_artifacts:0.2@zip");
        }
        config.setTransitive(false); // if required
        Configuration finalConfig = config.copy();

        project.copy(copySpec -> {
            copySpec.setFileMode(0755); //will make everything 755 but lets see if this works.
            copySpec.from(project.zipTree(finalConfig.getSingleFile()));
            copySpec.into(project.getBuildDir());
        });
    }

    private void addJavaDependsOnCOBOL(Project project) {
        Task javaCompile = project.getTasks().findByName("compileJava");
        assert javaCompile != null; //can never be null as cobol relies on java been in place
        Task cobolCompile = project.getTasks().findByName("compileCOBOL");
        javaCompile.dependsOn(cobolCompile);
    }

    private void addIntermediateJavaSource(Project project) {
        final JavaPluginConvention javaPlugin = project.getConvention().getPlugin(JavaPluginConvention.class);
        final SourceSetContainer sourceSets = javaPlugin.getSourceSets();
        SourceSet main = javaPlugin.getSourceSets().findByName(SourceSet.MAIN_SOURCE_SET_NAME);
        main.getJava().srcDir(new File(project.getBuildDir() + "/generated/src/main/intermediate_java")); //TODO should get from COBOL sourceset config
    }

    private void createSourceSetDefaults(Project project) {
        project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(new Action<SourceSet>() {
            @Override
            public void execute(final SourceSet sourceSet) {
                final COBOLSourceSet COBOLDefaultSourceSet = new COBOLSourceSet(COBOLSourceSet.LANG_NAME, project.getObjects());
                new DslObject(sourceSet).getConvention().getPlugins().put(COBOLSourceSet.LANG_NAME, COBOLDefaultSourceSet);

                COBOLDefaultSourceSet.getCOBOL().srcDir("src/" + sourceSet.getName() + "/COBOL");
                sourceSet.getResources().getFilter().exclude(new Spec<FileTreeElement>() {
                    @Override
                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return COBOLDefaultSourceSet.getCOBOL().contains(element.getFile());
                    }
                });
                sourceSet.getAllJava().source(COBOLDefaultSourceSet.getCOBOL());
                sourceSet.getAllSource().source(COBOLDefaultSourceSet.getCOBOL());

                final TaskProvider<CompileCOBOLTask> compileTask
                        = project.getTasks().register(sourceSet.getCompileTaskName("COBOL"),
                                                        CompileCOBOLTask.class, new Action<CompileCOBOLTask>() {
                        @Override
                    public void execute(final CompileCOBOLTask compile) {
//                        JvmPluginsHelper.configureForSourceSet(sourceSet, COBOLDefaultSourceSet.getCOBOL(), compile, compile.getOptions(), project);
                        compile.setDescription("Compiles the " + sourceSet.getName() + " COBOL source.");
                        compile.setSource(COBOLDefaultSourceSet.getCOBOL());
                        FileCollection classpath = project.files(new File("ddd"),new File("ddda"));
                        compile.setClasspath(classpath);
                        compile.setDestinationDir(new File(project.getBuildDir() + "/generated/src/main/intermediate_java") );
                    }
                });
                JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, COBOLDefaultSourceSet.getCOBOL(), project, compileTask, compileTask.map((Transformer<CompileOptions, CompileCOBOLTask>) COBOLCompile -> COBOLCompile.getOptions()));
            }
        });

    }
}