/*
 * Decompiled with CFR 0.152.
 */
package cc.heirloom.gradle.cobol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;

class ExecCustomizer
implements ExecSpec,
Serializable {
    private final transient Project project;
    @Nullable
    private String executable;
    @Nullable
    private List<String> arguments;
    @Nullable
    private Map<String, String> environment;
    @Nullable
    private Boolean ignoreExitValue;
    @Nullable
    private File workingDir;
    @Nullable
    private InputStream standardInput;
    @Nullable
    private OutputStream standardOutput;
    @Nullable
    private OutputStream standardError;

    ExecCustomizer(Project project) {
        this.project = (Project)Preconditions.checkNotNull((Object)project, (Object)"project");
    }

    public void setCommandLine(List<String> args) {
        this.commandLine(args);
    }

    public void setCommandLine(Object ... args) {
        this.commandLine(Arrays.asList(args));
    }

    public void setCommandLine(Iterable<?> args) {
        this.commandLine(args);
    }

    public ExecSpec commandLine(Object ... args) {
        return this.commandLine(Arrays.asList(args));
    }

    public ExecSpec commandLine(Iterable<?> args) {
        ImmutableList argsList = ImmutableList.copyOf(args);
        this.executable(argsList.get(0));
        this.setArgs(argsList.subList(1, argsList.size()));
        return this;
    }

    public ExecSpec args(Object ... args) {
        return this.args(Arrays.asList(args));
    }

    public ExecSpec args(Iterable<?> args) {
        Streams.stream(args).map(Object::toString).forEach(this.arguments()::add);
        return this;
    }

    public ExecSpec setArgs(List<String> args) {
        return this.setArgs((Iterable<?>)args);
    }

    public ExecSpec setArgs(Iterable<?> args) {
        this.arguments().clear();
        this.args(args);
        return this;
    }

    public List<String> getArgs() {
        return this.arguments();
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return ImmutableList.of();
    }

    public BaseExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public boolean isIgnoreExitValue() {
        return Boolean.TRUE.equals(this.ignoreExitValue);
    }

    public BaseExecSpec setStandardInput(InputStream inputStream) {
        this.standardInput = inputStream;
        return this;
    }

    @Nullable
    public InputStream getStandardInput() {
        return this.standardInput;
    }

    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        this.standardOutput = outputStream;
        return this;
    }

    @Nullable
    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.standardError = outputStream;
        return this;
    }

    @Nullable
    public OutputStream getErrorOutput() {
        return this.standardError;
    }

    public List<String> getCommandLine() {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getExecutable());
        commandLine.addAll(this.getArgs());
        return commandLine;
    }

    @Nullable
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = (String)Preconditions.checkNotNull((Object)executable, (Object)"executable");
    }

    public void setExecutable(Object executable) {
        Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.executable = executable.toString();
    }

    public ProcessForkOptions executable(Object executable) {
        Preconditions.checkNotNull((Object)executable, (Object)"executable");
        this.setExecutable(executable);
        return this;
    }

    public File getWorkingDir() {
        File workingDir = this.workingDir;
        return workingDir != null ? workingDir : this.project.getProjectDir();
    }

    public void setWorkingDir(File dir) {
        this.workingDir = (File)Preconditions.checkNotNull((Object)dir, (Object)"dir");
    }

    public void setWorkingDir(Object dir) {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        this.setWorkingDir(this.project.file(dir));
    }

    public ProcessForkOptions workingDir(Object dir) {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        this.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        return ImmutableMap.copyOf(this.environment());
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        Preconditions.checkNotNull(environmentVariables, (Object)"environmentVariables");
        this.environment().clear();
        environmentVariables.forEach((key, value) -> this.environment().put((String)key, value == null ? null : value.toString()));
    }

    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        Preconditions.checkNotNull(environmentVariables, (Object)"environmentVariables");
        this.setEnvironment(environmentVariables);
        return this;
    }

    public ProcessForkOptions environment(String name, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        this.environment().put(name, value.toString());
        return this;
    }

    public ProcessForkOptions copyTo(ProcessForkOptions options) {
        throw new UnsupportedOperationException("copyTo other options is not supported by this task.");
    }

    void copyTo(ExecSpec exec) {
        if (this.executable != null) {
            exec.executable((Object)this.executable);
        }
        if (this.arguments != null) {
            exec.args(this.arguments);
        }
        if (this.environment != null) {
            exec.environment(this.environment);
        }
        if (this.ignoreExitValue != null) {
            exec.setIgnoreExitValue(this.ignoreExitValue.booleanValue());
        }
        if (this.workingDir != null) {
            exec.workingDir((Object)this.workingDir);
        }
        if (this.standardInput != null) {
            exec.setStandardInput(this.standardInput);
        }
        if (this.standardOutput != null) {
            exec.setStandardOutput(this.standardOutput);
        }
        if (this.standardError != null) {
            exec.setErrorOutput(this.standardError);
        }
    }

    boolean isSerializable() {
        return this.standardInput == null && this.standardOutput == null && this.standardError == null;
    }

    private List<String> arguments() {
        if (this.arguments != null) {
            return this.arguments;
        }
        this.arguments = new ArrayList<String>();
        return this.arguments;
    }

    private Map<String, String> environment() {
        if (this.environment != null) {
            return this.environment;
        }
        this.environment = new HashMap<String, String>();
        return this.environment;
    }
}

