
package cc.heirloom.gradle.cobol;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.gradle.workers.WorkerExecutor;

/** Utility for invoking external programs. */
public final class ExternalExecUtil {

  /**
   * Executes an external program by customizing a {@link ExecSpec} with the supplied {@link
   * Action}. If the customized {@link ExecSpec} is serializable, the execution will happen in
   * parallel with others by running in {@link WorkerExecutor}, otherwise it will be invoked
   * serially.
   */
  public static void exec(
      Project project, WorkerExecutor workerExecutor, Action<? super ExecSpec> action) {
    ExecCustomizer customizer = new ExecCustomizer(project);
    action.execute(customizer);
    if (customizer.isSerializable()) {
      project.getLogger().info("Executing command in worker executor.");
      workerExecutor
          .noIsolation()
          .submit(
              COBOLCompileWorkAction.class, parameters -> parameters.getExecCustomizer().set(customizer));
    } else {
      project.getLogger().info("Executing command serially.");
      project.exec(customizer::copyTo);
    }
  }

  private ExternalExecUtil() {}
}
