

package cc.heirloom.gradle.cobol;

import static com.google.common.base.Preconditions.checkNotNull;

import javax.inject.Inject;

import org.gradle.api.provider.Property;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;

/** A {@link WorkAction} to execute an external process with the given customizer. */
public abstract class ExecWorkAction implements WorkAction<ExecWorkAction.Parameters> {

  private final ExecOperations exec;

  @SuppressWarnings("InjectOnConstructorOfAbstractClass")
  @Inject
  public ExecWorkAction(ExecOperations exec) {
    this.exec = checkNotNull(exec, "exec");
  }

  @Override
  public void execute() {
    exec.exec(exec -> getParameters().getExecCustomizer().get().copyTo(exec));
  }

  public interface Parameters extends WorkParameters {
    Property<ExecCustomizer> getExecCustomizer();
  }
}
