package cc.heirloom.gradle.cobol;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;


public class COBOLPlugin implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply("java");
        Task javaCompile = project.getTasks().findByName("compileJava");
        assert javaCompile != null; //can never be null as cobol relies on java been in place
        project.getTasks().create("compileCOBOL", CompileCOBOLTask.class, javaCompile::dependsOn);
    }
}