/*
 * Decompiled with CFR 0.152.
 */
package cc.heirloom.gradle.cobol;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;
import org.gradle.workers.WorkerExecutor;

public class CompileCOBOLTask
extends SourceTask {
    private final ConfigurableFileCollection cobolSourcePath;
    private final DirectoryProperty destinationDirectory;
    private final WorkerExecutor workerExec;
    private final ExecOperations execOperations;

    @Inject
    public CompileCOBOLTask(ObjectFactory objectFactory, WorkerExecutor workerExec, ExecOperations execOperations) {
        this.execOperations = execOperations;
        this.cobolSourcePath = this.getProject().files(new Object[0]);
        this.destinationDirectory = objectFactory.directoryProperty();
        this.workerExec = workerExec;
    }

    @InputFiles
    public ConfigurableFileCollection getCobolSourcePath() {
        return this.cobolSourcePath;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @TaskAction
    void doCOBOLCompile() {
        File COBOLExe = OperatingSystem.current().findInPath("ecobol.exe");
        for (File sourceFile : this.getSource().getFiles()) {
            this.getProject().exec(execSpec -> {
                execSpec.executable((Object)"/dev/ecobol.exe");
                execSpec.args(new Object[]{"-cc"});
                execSpec.args(new Object[]{sourceFile.toString()});
                execSpec.args(new Object[]{"-out:dir"});
                execSpec.args(new Object[]{((Directory)this.destinationDirectory.get()).getAsFile().toString()});
            }).assertNormalExitValue();
        }
    }
}

