package cc.heirloom.gradle.cobol;

import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;

import org.gradle.api.tasks.*;
import org.gradle.api.file.DirectoryProperty;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;

import org.gradle.process.ExecSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;


import javax.inject.Inject;
import java.io.File;


public class CompileCOBOLTask extends SourceTask {

    private final ConfigurableFileCollection cobolSourcePath;
    private final DirectoryProperty destinationDirectory;
    private final WorkerExecutor workerExec;
    private final ExecOperations execOperations;

    @Inject
    public  CompileCOBOLTask(ObjectFactory objectFactory, WorkerExecutor workerExec, ExecOperations execOperations) {
        super();
        this.execOperations = execOperations;
        this.cobolSourcePath = getProject().files();
        this.destinationDirectory = objectFactory.directoryProperty();
        this.workerExec = workerExec;

    }

    @InputFiles
    public ConfigurableFileCollection getCobolSourcePath() {
        return cobolSourcePath;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return destinationDirectory;
    }

    @TaskAction
    void doCOBOLCompile() {

        File COBOLExe = OperatingSystem.current().findInPath("ecobol.exe");
        for (File sourceFile : getSource().getFiles()) {
            getProject().exec(execSpec -> {
                execSpec.executable("/dev/ecobol.exe");
                execSpec.args("-cc");
                execSpec.args(sourceFile.toString());
                execSpec.args("-out:dir");
                execSpec.args(destinationDirectory.get().getAsFile().toString());

            }
            ).assertNormalExitValue();
        }
    }

}