/*
 * Decompiled with CFR 0.152.
 */
package cc.freiberg.paapi.client;

import cc.freiberg.paapi.client.PaapiParams;
import com.ecs.client.jax.AWSECommerceServicePortType;
import com.ecs.client.jax.BrowseNodeLookupRequest;
import com.ecs.client.jax.BrowseNodes;
import com.ecs.client.jax.Errors;
import com.ecs.client.jax.OperationRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseNodeRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BrowseNodeRequestHandler.class);
    private final String marketplace;
    private final String accessKeyId;
    private final String tag;
    private final AWSECommerceServicePortType port;

    public BrowseNodeRequestHandler(String marketplace, String accessKeyId, String tag, AWSECommerceServicePortType port) {
        this.marketplace = marketplace;
        this.accessKeyId = accessKeyId;
        this.tag = tag;
        this.port = port;
    }

    List<BrowseNodes> browseNodeLookup(BrowseNodeLookupRequest request, PaapiParams params) {
        ArrayList<BrowseNodeLookupRequest> requests = new ArrayList<BrowseNodeLookupRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.browseNodeLookup(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<BrowseNodes>>)result);
        LOG.info("browseNodeLookup took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            BrowseNodeRequestHandler.checkForErrors((Holder<List<BrowseNodes>>)result);
        }
        return (List)result.value;
    }

    static void checkForErrors(Holder<List<BrowseNodes>> result) {
        if (!((List)result.value).isEmpty() && ((BrowseNodes)((List)result.value).get(0)).getRequest().getErrors() == null && "True".equalsIgnoreCase(((BrowseNodes)((List)result.value).get(0)).getRequest().getIsValid())) {
            return;
        }
        String errorMessage = ((List)result.value).stream().flatMap(i -> i.getRequest().getErrors().getError().stream()).map(e -> BrowseNodeRequestHandler.makeString(e)).collect(Collectors.joining(System.lineSeparator()));
        throw new IllegalArgumentException(errorMessage);
    }

    static String makeString(Errors.Error error) {
        return error.getCode() + ": " + error.getMessage();
    }
}

