/*
 * Decompiled with CFR 0.152.
 */
package cc.freiberg.paapi.client;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AWSConfig.class);
    private static final String AMAZON_BUNDLE = "amazon";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("amazon");

    private AWSConfig() {
    }

    public static String getMarketplace() {
        return AWSConfig.getValue("amazon.paapi.marketplace");
    }

    public static String getAccesKey() {
        return AWSConfig.getValue("amazon.accessKeyId");
    }

    public static String getSecretKey() {
        return AWSConfig.getValue("amazon.secretKey");
    }

    public static String getTag() {
        return AWSConfig.getValue("amazon.paapi.tag");
    }

    private static String getValue(String key) {
        if (System.getenv(key.substring(key.lastIndexOf("."))) != null) {
            return System.getenv(key);
        }
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.error("Missing property {}", (Object)key, (Object)e);
            return null;
        }
    }
}

