/*
 * Decompiled with CFR 0.152.
 */
package cc.freiberg.paapi.client;

import cc.freiberg.paapi.client.AwsHandlerResolver;
import cc.freiberg.paapi.client.BrowseNodeRequestHandler;
import cc.freiberg.paapi.client.CartRequestHandler;
import cc.freiberg.paapi.client.ItemRequestHandler;
import cc.freiberg.paapi.client.PaapiClient;
import cc.freiberg.paapi.client.PaapiParams;
import cc.freiberg.paapi.client.WebServiceWrapper;
import com.ecs.client.jax.AWSECommerceService;
import com.ecs.client.jax.AWSECommerceServicePortType;
import com.ecs.client.jax.BrowseNodeLookupRequest;
import com.ecs.client.jax.BrowseNodes;
import com.ecs.client.jax.Cart;
import com.ecs.client.jax.CartAddRequest;
import com.ecs.client.jax.CartClearRequest;
import com.ecs.client.jax.CartCreateRequest;
import com.ecs.client.jax.CartGetRequest;
import com.ecs.client.jax.CartModifyRequest;
import com.ecs.client.jax.ItemLookupRequest;
import com.ecs.client.jax.ItemSearchRequest;
import com.ecs.client.jax.Items;
import com.ecs.client.jax.SimilarityLookupRequest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaapiClientImpl
implements PaapiClient {
    private static final Logger LOG = LoggerFactory.getLogger(PaapiClientImpl.class);
    private int retryMax = 3;
    private long retryIntervallMillis = 1000L;
    private final PaapiParams params;
    private final ItemRequestHandler itemHandler;
    private final BrowseNodeRequestHandler browseNodeHandler;
    private final CartRequestHandler cartHandler;

    public PaapiClientImpl(String marketplace, String accessKeyId, String secretAccessKey, String tag) {
        PaapiClientImpl.checkArgs(marketplace, accessKeyId, secretAccessKey, tag);
        AWSECommerceService service = new AWSECommerceService();
        service.setHandlerResolver(new AwsHandlerResolver(secretAccessKey));
        AWSECommerceServicePortType port = service.getAWSECommerceServicePortDE();
        this.params = new PaapiParams(true, false);
        this.itemHandler = new ItemRequestHandler(marketplace, accessKeyId, tag, port);
        this.browseNodeHandler = new BrowseNodeRequestHandler(marketplace, accessKeyId, tag, port);
        this.cartHandler = new CartRequestHandler(marketplace, accessKeyId, tag, port);
        LOG.debug("Create PaapiClient for {} - {} - {}", new Object[]{marketplace, accessKeyId, tag});
    }

    private static void checkArgs(String marketplace, String accessKeyId, String secretAccessKeyId, String tag) throws IllegalArgumentException {
        PaapiClientImpl.checkNullOrEmpty(marketplace, "marketplace");
        PaapiClientImpl.checkNullOrEmpty(accessKeyId, "accessKeyId");
        PaapiClientImpl.checkNullOrEmpty(secretAccessKeyId, "secretAccessKeyId");
        PaapiClientImpl.checkNullOrEmpty(tag, "tag");
    }

    private static void checkNullOrEmpty(String string, String name) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " is empty.");
        }
    }

    @Override
    public List<Items> itemSearch(final ItemSearchRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Items>>(){

            @Override
            public List<Items> call() throws WebServiceException {
                return PaapiClientImpl.this.itemHandler.itemSearch(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<BrowseNodes> browseNodeLookup(final BrowseNodeLookupRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<BrowseNodes>>(){

            @Override
            public List<BrowseNodes> call() throws WebServiceException {
                return PaapiClientImpl.this.browseNodeHandler.browseNodeLookup(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Items> itemLookup(final ItemLookupRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Items>>(){

            @Override
            public List<Items> call() throws WebServiceException {
                return PaapiClientImpl.this.itemHandler.itemLookup(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Items> similarityLookup(final SimilarityLookupRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Items>>(){

            @Override
            public List<Items> call() throws WebServiceException {
                return PaapiClientImpl.this.itemHandler.similarityLookup(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Cart> cartAdd(final CartAddRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Cart>>(){

            @Override
            public List<Cart> call() throws WebServiceException {
                return PaapiClientImpl.this.cartHandler.cartAdd(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Cart> cartCreate(final CartCreateRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Cart>>(){

            @Override
            public List<Cart> call() throws WebServiceException {
                return PaapiClientImpl.this.cartHandler.cartCreate(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Cart> cartClear(final CartClearRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Cart>>(){

            @Override
            public List<Cart> call() throws WebServiceException {
                return PaapiClientImpl.this.cartHandler.cartClear(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Cart> cartGet(final CartGetRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Cart>>(){

            @Override
            public List<Cart> call() throws WebServiceException {
                return PaapiClientImpl.this.cartHandler.cartGet(request, PaapiClientImpl.this.params);
            }
        });
    }

    @Override
    public List<Cart> cartModify(final CartModifyRequest request) {
        return this.callWithRetry(new WebServiceWrapper<List<Cart>>(){

            @Override
            public List<Cart> call() throws WebServiceException {
                return PaapiClientImpl.this.cartHandler.cartModify(request, PaapiClientImpl.this.params);
            }
        });
    }

    <T> T callWithRetry(WebServiceWrapper<T> wrapper) throws WebServiceException {
        int retry = 0;
        boolean completed = false;
        T result = null;
        while (true) {
            try {
                result = wrapper.call();
            }
            catch (WebServiceException e) {
                if (e.getMessage().contains("503")) {
                    LOG.warn("Product Advertising API currently unavailable.", (Throwable)e);
                    if (retry >= this.retryMax) break;
                    LOG.debug("Running retry attempt {}/{}", new Object[]{++retry, this.retryMax, e});
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.retryIntervallMillis * (long)retry);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    continue;
                }
                throw e;
            }
            break;
        }
        return result;
    }

    public int getRetryMax() {
        return this.retryMax;
    }

    public void setRetryMax(int retryMax) {
        this.retryMax = retryMax;
    }

    public long getRetryIntervallMillis() {
        return this.retryIntervallMillis;
    }

    public void setRetryIntervallMillis(long retryIntervallMillis) {
        this.retryIntervallMillis = retryIntervallMillis;
    }

    public boolean isValidating() {
        return this.params.isValidate();
    }

    public void setValidating(boolean validating) {
        this.params.setValidate(validating);
    }

    public boolean isEscaping() {
        return this.params.isEscaping();
    }

    public void setEscaping(boolean escaping) {
        this.params.setEscaping(escaping);
    }
}

