/*
 * Decompiled with CFR 0.152.
 */
package cc.freiberg.paapi.client;

import cc.freiberg.paapi.client.PaapiParams;
import com.ecs.client.jax.AWSECommerceServicePortType;
import com.ecs.client.jax.Errors;
import com.ecs.client.jax.ItemLookupRequest;
import com.ecs.client.jax.ItemSearchRequest;
import com.ecs.client.jax.Items;
import com.ecs.client.jax.OperationRequest;
import com.ecs.client.jax.SimilarityLookupRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ItemRequestHandler.class);
    private final String marketplace;
    private final String accessKeyId;
    private final String tag;
    private final AWSECommerceServicePortType port;

    public ItemRequestHandler(String marketplace, String accessKeyId, String tag, AWSECommerceServicePortType port) {
        this.marketplace = marketplace;
        this.accessKeyId = accessKeyId;
        this.tag = tag;
        this.port = port;
    }

    List<Items> itemSearch(ItemSearchRequest request, PaapiParams params) {
        ArrayList<ItemSearchRequest> requests = new ArrayList<ItemSearchRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.itemSearch(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Items>>)result);
        LOG.info("itemSearch took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            ItemRequestHandler.checkForErrors((Holder<List<Items>>)result);
        }
        return (List)result.value;
    }

    List<Items> itemLookup(ItemLookupRequest request, PaapiParams params) {
        ArrayList<ItemLookupRequest> requests = new ArrayList<ItemLookupRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.itemLookup(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Items>>)result);
        LOG.info("itemLookup took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            ItemRequestHandler.checkForErrors((Holder<List<Items>>)result);
        }
        return (List)result.value;
    }

    List<Items> similarityLookup(SimilarityLookupRequest request, PaapiParams params) {
        ArrayList<SimilarityLookupRequest> requests = new ArrayList<SimilarityLookupRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.similarityLookup(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Items>>)result);
        LOG.info("similarityLookup took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            ItemRequestHandler.checkForErrors((Holder<List<Items>>)result);
        }
        return (List)result.value;
    }

    static void checkForErrors(Holder<List<Items>> result) {
        if (!((List)result.value).isEmpty() && ((Items)((List)result.value).get(0)).getRequest().getErrors() == null && "True".equalsIgnoreCase(((Items)((List)result.value).get(0)).getRequest().getIsValid())) {
            return;
        }
        String errorMessage = ((List)result.value).stream().flatMap(i -> i.getRequest().getErrors().getError().stream()).map(e -> ItemRequestHandler.makeString(e)).collect(Collectors.joining(System.lineSeparator()));
        throw new IllegalArgumentException(errorMessage);
    }

    static String makeString(Errors.Error error) {
        return error.getCode() + ": " + error.getMessage();
    }
}

