/*
 * Decompiled with CFR 0.152.
 */
package cc.freiberg.paapi.client;

import cc.freiberg.paapi.client.PaapiParams;
import com.ecs.client.jax.AWSECommerceServicePortType;
import com.ecs.client.jax.Cart;
import com.ecs.client.jax.CartAddRequest;
import com.ecs.client.jax.CartClearRequest;
import com.ecs.client.jax.CartCreateRequest;
import com.ecs.client.jax.CartGetRequest;
import com.ecs.client.jax.CartModifyRequest;
import com.ecs.client.jax.Errors;
import com.ecs.client.jax.OperationRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CartRequestHandler.class);
    private final String marketplace;
    private final String accessKeyId;
    private final String tag;
    private final AWSECommerceServicePortType port;

    public CartRequestHandler(String marketplace, String accessKeyId, String tag, AWSECommerceServicePortType port) {
        this.marketplace = marketplace;
        this.accessKeyId = accessKeyId;
        this.tag = tag;
        this.port = port;
    }

    List<Cart> cartCreate(CartCreateRequest request, PaapiParams params) {
        ArrayList<CartCreateRequest> requests = new ArrayList<CartCreateRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartCreate(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartCreate took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    List<Cart> cartAdd(CartAddRequest request, PaapiParams params) {
        ArrayList<CartAddRequest> requests = new ArrayList<CartAddRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartAdd(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartAdd took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    List<Cart> cartAdd(CartClearRequest request, PaapiParams params) {
        ArrayList<CartClearRequest> requests = new ArrayList<CartClearRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartClear(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartAdd took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    List<Cart> cartGet(CartGetRequest request, PaapiParams params) {
        ArrayList<CartGetRequest> requests = new ArrayList<CartGetRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartGet(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartGet took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    List<Cart> cartModify(CartModifyRequest request, PaapiParams params) {
        ArrayList<CartModifyRequest> requests = new ArrayList<CartModifyRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartModify(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartModify took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    List<Cart> cartClear(CartClearRequest request, PaapiParams params) {
        ArrayList<CartClearRequest> requests = new ArrayList<CartClearRequest>();
        Holder operationRequest = new Holder();
        Holder result = new Holder();
        this.port.cartClear(this.marketplace, this.accessKeyId, this.tag, params.getValidating(), params.getEscaping(), request, requests, (Holder<OperationRequest>)operationRequest, (Holder<List<Cart>>)result);
        LOG.info("cartModify took {}", (Object)((OperationRequest)operationRequest.value).getRequestProcessingTime());
        if (params.isValidate()) {
            CartRequestHandler.checkForErrors((Holder<List<Cart>>)result);
        }
        return (List)result.value;
    }

    static void checkForErrors(Holder<List<Cart>> result) {
        if (!((List)result.value).isEmpty() && ((Cart)((List)result.value).get(0)).getRequest().getErrors() == null && "True".equalsIgnoreCase(((Cart)((List)result.value).get(0)).getRequest().getIsValid())) {
            return;
        }
        String errorMessage = ((List)result.value).stream().flatMap(i -> i.getRequest().getErrors().getError().stream()).map(e -> CartRequestHandler.makeString(e)).collect(Collectors.joining(System.lineSeparator()));
        throw new IllegalArgumentException(errorMessage);
    }

    static String makeString(Errors.Error error) {
        return error.getCode() + ": " + error.getMessage();
    }
}

