/*
 * Decompiled with CFR 0.152.
 */
package cc.ecore.spring.jfinal.plugin;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.util.Assert;

public class SpringKit {
    public static FileSystemXmlApplicationContext newFileSystemXmlApplicationContextByConfigurations(String ... configurations) {
        Assert.notNull((Object)configurations);
        return new FileSystemXmlApplicationContext(configurations);
    }

    public static AnnotationConfigApplicationContext newAnnotationConfigApplicationContextByBasePackages(String ... basePackages) {
        Assert.notNull((Object)basePackages);
        return new AnnotationConfigApplicationContext(basePackages);
    }

    public static AnnotationConfigApplicationContext newAnnotationConfigApplicationContextByAnnotatedClasses(Class<?> ... annotatedClasses) {
        Assert.notNull(annotatedClasses);
        return new AnnotationConfigApplicationContext((Class[])annotatedClasses);
    }

    public static AnnotationConfigApplicationContext newAnnotationConfigApplicationContextByAnnotatedClasses(String ... annotatedClasses) {
        return SpringKit.newAnnotationConfigApplicationContextByAnnotatedClasses(SpringKit.forNames(annotatedClasses));
    }

    public static ClassPathXmlApplicationContext newClassPathXmlApplicationContextByConfigLocations(String ... configLocations) {
        Assert.notNull((Object)configLocations);
        return new ClassPathXmlApplicationContext(configLocations);
    }

    public static BeanDefinitionBuilder genericBean(Class<?> serviceClass) {
        Assert.notNull(serviceClass);
        return BeanDefinitionBuilder.genericBeanDefinition(serviceClass);
    }

    public static BeanDefinitionBuilder genericBean(String beanClassName) {
        Assert.notNull((Object)beanClassName);
        return BeanDefinitionBuilder.genericBeanDefinition((String)beanClassName);
    }

    public static void registerBean(ApplicationContext context, String beanName, BeanDefinition beanDefinition) {
        Assert.notNull((Object)context);
        Assert.state((!context.containsBean(beanName) ? 1 : 0) != 0, (String)("bean [" + beanName + "] is exist."));
        Assert.notNull((Object)beanDefinition);
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)context;
        BeanDefinitionRegistry beanDefinitonRegistry = (BeanDefinitionRegistry)configurableApplicationContext.getBeanFactory();
        beanDefinitonRegistry.registerBeanDefinition(beanName, beanDefinition);
    }

    static Class<?>[] forNames(String ... classNames) {
        int length = 0;
        if (classNames != null) {
            length = classNames.length;
        }
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = SpringKit.forName(classNames[i]);
        }
        return classes;
    }

    static <T> Class<T> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

