/*
 * Decompiled with CFR 0.152.
 */
package cc.ecore.spring.jfinal.plugin;

import com.jfinal.core.Controller;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class IocKit {
    static AutowiredAnnotationBeanPostProcessor processor;
    private static Method getController;
    private static Method invoke;
    private static Class<?> invocationClass;

    public static void invokeForProcessInjection(Object invocation) {
        Controller controller = IocKit.getController(invocation);
        processor.processInjection((Object)controller);
        IocKit.invoke(invocation);
    }

    public static void invokeForProcessInjection(Object invocation, boolean check) {
        if (check) {
            Assert.notNull((Object)invocation, (String)"invocation not be null");
            Class<?> clazz = invocation.getClass();
            String name = clazz.getName();
            int mod = clazz.getModifiers();
            Assert.isTrue((Modifier.isAbstract(mod) || Modifier.isInterface(mod) ? 1 : 0) != 0, (String)("[%s" + name + "] is not a abstract or interface"));
            Assert.isTrue((boolean)invocationClass.isAssignableFrom(clazz), (String)("[" + name + "] is not a subclass of [" + invocationClass.getName() + "]."));
        }
        IocKit.invokeForProcessInjection(invocation);
    }

    static void invoke(Object invocation) {
        ReflectionUtils.invokeMethod((Method)invoke, (Object)invocation);
    }

    static Controller getController(Object invocation) {
        return (Controller)ReflectionUtils.invokeMethod((Method)getController, (Object)invocation);
    }

    static {
        try {
            invocationClass = Class.forName("com.jfinal.aop.Invocation");
        }
        catch (ClassNotFoundException e) {
            try {
                invocationClass = Class.forName("com.jfinal.core.ActionInvocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        getController = ReflectionUtils.findMethod(invocationClass, (String)"getController");
        invoke = ReflectionUtils.findMethod(invocationClass, (String)"invoke");
    }
}

