/*
 * Decompiled with CFR 0.152.
 */
package cc.eamon.open.mapping.mapper.processor;

import cc.eamon.open.mapping.ProcessingException;
import cc.eamon.open.mapping.mapper.MapperExtra;
import cc.eamon.open.mapping.mapper.MapperIgnoreDetail;
import cc.eamon.open.mapping.mapper.MapperModifyDetail;
import cc.eamon.open.mapping.mapper.MapperRenameDetail;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class MapProcessor {
    public static MethodSpec buildGetMapExtraMethod(ClassName self, String mapperName, List<Element> elemFields, Map<String, MapperIgnoreDetail> ignoreDetailMap, Map<String, MapperModifyDetail> modifyDetailMap, Map<String, MapperRenameDetail> renameDetailMap, MapperExtra mapperExtra, TypeElement typeElement, TypeSpec.Builder typeSpec) throws ProcessingException {
        ClassName string = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
        ClassName object = ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]);
        ClassName map = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
        ClassName linkedHashMap = ClassName.get((String)"java.util", (String)"LinkedHashMap", (String[])new String[0]);
        ParameterizedTypeName typeOfMap = ParameterizedTypeName.get((ClassName)map, (TypeName[])new TypeName[]{string, object});
        String realMethodName = "getMapWithExtra";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)realMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)self, "obj", new Modifier[0]).returns((TypeName)typeOfMap);
        methodSpec.addStatement("Map<String, Object> resultMap = new $T<>()", new Object[]{linkedHashMap});
        methodSpec.addStatement("if (obj == null) return resultMap", new Object[0]);
        MapProcessor.mapProc(mapperName, elemFields, ignoreDetailMap, modifyDetailMap, renameDetailMap, methodSpec);
        int index = 0;
        for (int i = 0; i < mapperExtra.value().length; ++i) {
            String name;
            String clazz;
            if (!mapperName.equals(mapperExtra.value()[i])) continue;
            index = i;
            if (mapperExtra.type().length > 0 && mapperExtra.type().length <= index) {
                clazz = mapperExtra.type()[mapperExtra.list().length - 1];
            } else if (mapperExtra.type().length > 0) {
                clazz = mapperExtra.type()[index];
            } else {
                throw new ProcessingException(typeElement, "MapperExtra: Type Can't Be Empty", new Object[0]);
            }
            if (mapperExtra.name().length > 0 && mapperExtra.name().length <= index) {
                name = mapperExtra.name()[mapperExtra.list().length - 1];
            } else if (mapperExtra.name().length > 0) {
                name = mapperExtra.name()[index];
            } else {
                throw new ProcessingException(typeElement, "MapperExtra: Name Can't Be Empty", new Object[0]);
            }
            boolean list = mapperExtra.list().length > 0 && mapperExtra.list().length <= index ? mapperExtra.list()[mapperExtra.list().length - 1] : (mapperExtra.list().length > 0 ? mapperExtra.list()[index] : false);
            String pkgName = clazz.replaceAll("\\.[^\\.]+$", "");
            String clazzName = clazz.replaceAll(".*\\.", "");
            ClassName className = ClassName.get((String)pkgName, (String)clazzName, (String[])new String[0]);
            if (clazzName.equals("Map")) {
                className = typeOfMap;
            }
            if (list) {
                ClassName listClazz = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
                FieldSpec fieldSpec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)listClazz, (TypeName[])new TypeName[]{className}), (String)name, (Modifier[])new Modifier[]{Modifier.PUBLIC}).build();
                typeSpec.addField(fieldSpec);
                methodSpec.addParameter((TypeName)ParameterizedTypeName.get((ClassName)listClazz, (TypeName[])new TypeName[]{className}), name, new Modifier[0]);
                methodSpec.addStatement("resultMap.put(\"" + name + "\", " + name + ")", new Object[0]);
                continue;
            }
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)className, (String)name, (Modifier[])new Modifier[]{Modifier.PUBLIC}).build();
            typeSpec.addField(fieldSpec);
            methodSpec.addParameter((TypeName)className, name, new Modifier[0]);
            methodSpec.addStatement("resultMap.put(\"" + name + "\", " + name + ")", new Object[0]);
        }
        methodSpec.addStatement("return resultMap", new Object[0]);
        return methodSpec.build();
    }

    public static MethodSpec buildGetMapMethod(ClassName self, String mapperName, List<Element> elemFields, Map<String, MapperIgnoreDetail> ignoreDetailMap, Map<String, MapperModifyDetail> modifyDetailMap, Map<String, MapperRenameDetail> renameDetailMap) {
        ClassName string = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
        ClassName object = ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]);
        ClassName map = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
        ClassName linkedHashMap = ClassName.get((String)"java.util", (String)"LinkedHashMap", (String[])new String[0]);
        ParameterizedTypeName typeOfMap = ParameterizedTypeName.get((ClassName)map, (TypeName[])new TypeName[]{string, object});
        String realMethodName = "getMap";
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)realMethodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)self, "obj", new Modifier[0]).returns((TypeName)typeOfMap);
        methodSpec.addStatement("Map<String, Object> resultMap = new $T<>()", new Object[]{linkedHashMap});
        methodSpec.addStatement("if (obj == null) return resultMap", new Object[0]);
        MapProcessor.mapProc(mapperName, elemFields, ignoreDetailMap, modifyDetailMap, renameDetailMap, methodSpec);
        methodSpec.addStatement("return resultMap", new Object[0]);
        return methodSpec.build();
    }

    private static void mapProc(String mapperName, List<Element> elemFields, Map<String, MapperIgnoreDetail> ignoreDetailMap, Map<String, MapperModifyDetail> modifyDetailMap, Map<String, MapperRenameDetail> renameDetailMap, MethodSpec.Builder methodSpec) {
        for (Element fieldElem : elemFields) {
            Object detail;
            String field = fieldElem.getSimpleName().toString();
            if (ignoreDetailMap.get(field) != null && ignoreDetailMap.get(field).checkIn(mapperName)) continue;
            if (modifyDetailMap.get(field) != null && renameDetailMap.get(field) == null) {
                if (modifyDetailMap.get(field).getValue(mapperName) != null) {
                    detail = modifyDetailMap.get(field).getValue(mapperName);
                    methodSpec.addStatement("resultMap.put(\"" + field + "\", obj." + ((MapperModifyDetail.ModifyDetail)detail).getModifyName() + "(obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "()))", new Object[0]);
                    continue;
                }
            } else if (renameDetailMap.get(field) != null && modifyDetailMap.get(field) == null) {
                if (renameDetailMap.get(field).getValue(mapperName) != null) {
                    detail = renameDetailMap.get(field).getValue(mapperName);
                    methodSpec.addStatement("resultMap.put(\"" + ((MapperRenameDetail.RenameDetail)detail).getRenameName() + "\", obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "())", new Object[0]);
                    continue;
                }
            } else if (modifyDetailMap.get(field) != null && renameDetailMap.get(field) != null) {
                if (modifyDetailMap.get(field).getValue(mapperName) != null && renameDetailMap.get(field).getValue(mapperName) != null) {
                    MapperModifyDetail.ModifyDetail modifyDetail = modifyDetailMap.get(field).getValue(mapperName);
                    MapperRenameDetail.RenameDetail renameDetail = renameDetailMap.get(field).getValue(mapperName);
                    methodSpec.addStatement("resultMap.put(\"" + renameDetail.getRenameName() + "\", obj." + modifyDetail.getModifyName() + "(obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "()))", new Object[0]);
                    continue;
                }
                if (renameDetailMap.get(field).getValue(mapperName) != null) {
                    detail = renameDetailMap.get(field).getValue(mapperName);
                    methodSpec.addStatement("resultMap.put(\"" + ((MapperRenameDetail.RenameDetail)detail).getRenameName() + "\", obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "())", new Object[0]);
                    continue;
                }
                if (modifyDetailMap.get(field).getValue(mapperName) != null) {
                    detail = modifyDetailMap.get(field).getValue(mapperName);
                    methodSpec.addStatement("resultMap.put(\"" + field + "\", obj." + ((MapperModifyDetail.ModifyDetail)detail).getModifyName() + "(obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "()))", new Object[0]);
                    continue;
                }
            }
            methodSpec.addStatement("resultMap.put(\"" + field + "\", obj.get" + field.substring(0, 1).toUpperCase() + field.substring(1) + "())", new Object[0]);
        }
    }
}

