/*
 * Decompiled with CFR 0.152.
 */
package cc.eamon.open.mapping.mapper;

import cc.eamon.open.mapping.ProcessingException;
import cc.eamon.open.mapping.mapper.Mapper;
import cc.eamon.open.mapping.mapper.MapperDoc;
import cc.eamon.open.mapping.mapper.MapperExtra;
import cc.eamon.open.mapping.mapper.MapperGroup;
import cc.eamon.open.mapping.mapper.MapperIgnore;
import cc.eamon.open.mapping.mapper.MapperIgnoreDetail;
import cc.eamon.open.mapping.mapper.MapperModify;
import cc.eamon.open.mapping.mapper.MapperModifyDetail;
import cc.eamon.open.mapping.mapper.MapperRename;
import cc.eamon.open.mapping.mapper.MapperRenameDetail;
import cc.eamon.open.mapping.mapper.processor.EntityProcessor;
import cc.eamon.open.mapping.mapper.processor.MapGroupProcessor;
import cc.eamon.open.mapping.mapper.processor.MapProcessor;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class MapperProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Mapper.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void scanFields(Element elem, List<Element> elemFields, Map<String, String> docDetailMap, Map<String, MapperIgnoreDetail> ignoreDetailMap, Map<String, MapperModifyDetail> modifyDetailMap, Map<String, MapperRenameDetail> renameDetailMap) {
        HashMap<String, TypeMirror> methodType = new HashMap<String, TypeMirror>();
        for (Element element : elem.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            methodType.put(element.getSimpleName().toString(), element.asType());
        }
        for (Element element : elem.getEnclosedElements()) {
            Object detail;
            if (!element.getKind().isField() || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            elemFields.add(element);
            MapperDoc doc = element.getAnnotation(MapperDoc.class);
            MapperIgnore ignore = element.getAnnotation(MapperIgnore.class);
            MapperModify modify = element.getAnnotation(MapperModify.class);
            MapperRename rename = element.getAnnotation(MapperRename.class);
            if (doc != null && !doc.value().equals("")) {
                docDetailMap.put(element.getSimpleName().toString(), doc.value());
            } else {
                docDetailMap.put(element.getSimpleName().toString(), "");
            }
            if (ignore != null) {
                detail = new MapperIgnoreDetail();
                ((MapperIgnoreDetail)detail).setFieldName(element.getSimpleName().toString());
                for (String s : ignore.value()) {
                    ((MapperIgnoreDetail)detail).addValue(s);
                }
                ignoreDetailMap.put(((MapperIgnoreDetail)detail).getFieldName(), (MapperIgnoreDetail)detail);
            }
            if (modify != null) {
                detail = new MapperModifyDetail();
                ((MapperModifyDetail)detail).setFieldName(element.getSimpleName().toString());
                for (int i = 0; i < modify.value().length; ++i) {
                    MapperModifyDetail.ModifyDetail modifyDetail = new MapperModifyDetail.ModifyDetail();
                    modifyDetail.setModifyName(modify.modify()[i]);
                    modifyDetail.setRecoverName(modify.recover()[i]);
                    modifyDetail.setTargetMapName(modify.value()[i]);
                    modifyDetail.setRecoverType((TypeMirror)methodType.get(modify.modify()[i]));
                    ((MapperModifyDetail)detail).addValue(modifyDetail);
                }
                modifyDetailMap.put(((MapperModifyDetail)detail).getFieldName(), (MapperModifyDetail)detail);
            }
            if (rename == null) continue;
            detail = new MapperRenameDetail();
            ((MapperRenameDetail)detail).setFieldName(element.getSimpleName().toString());
            for (int i = 0; i < rename.value().length; ++i) {
                MapperRenameDetail.RenameDetail renameDetail = new MapperRenameDetail.RenameDetail();
                renameDetail.setTargetMapName(rename.value()[i]);
                renameDetail.setRenameName(rename.name()[i]);
                ((MapperRenameDetail)detail).addValue(renameDetail);
            }
            renameDetailMap.put(((MapperRenameDetail)detail).getFieldName(), (MapperRenameDetail)detail);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(Mapper.class)) {
                if (element.getKind() != ElementKind.CLASS) {
                    throw new ProcessingException(element, "Only classes can be annotated with @%s", Mapper.class.getSimpleName());
                }
                ArrayList<Element> fields = new ArrayList<Element>();
                HashMap<String, String> docDetailMap = new HashMap<String, String>();
                HashMap<String, MapperIgnoreDetail> ignoreDetailMap = new HashMap<String, MapperIgnoreDetail>();
                HashMap<String, MapperModifyDetail> modifyDetailMap = new HashMap<String, MapperModifyDetail>();
                HashMap<String, MapperRenameDetail> renameDetailMap = new HashMap<String, MapperRenameDetail>();
                this.scanFields(element, fields, docDetailMap, ignoreDetailMap, modifyDetailMap, renameDetailMap);
                TypeElement typeElement = (TypeElement)element;
                Name qualifiedClassName = typeElement.getQualifiedName();
                Name simpleName = typeElement.getSimpleName();
                PackageElement pkg = this.elementUtils.getPackageOf(typeElement);
                String packageName = pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString();
                Mapper mapper = element.getAnnotation(Mapper.class);
                MapperExtra mapperExtra = element.getAnnotation(MapperExtra.class);
                MapperGroup mapperGroup = element.getAnnotation(MapperGroup.class);
                HashSet<String> mapperSet = new HashSet<String>();
                mapperSet.add("default");
                mapperSet.addAll(Arrays.asList(mapper.value()));
                HashSet<String> mapperExtraSet = new HashSet<String>();
                if (mapperExtra != null) {
                    if (mapperExtra.value().length == 0) {
                        mapperExtraSet.add("default");
                    } else {
                        mapperExtraSet.addAll(Arrays.asList(mapperExtra.value()));
                    }
                }
                HashSet<String> mapperGroupSet = new HashSet<String>();
                if (mapperGroup != null) {
                    if (mapperGroup.target().length == 0) {
                        mapperGroupSet.add("default");
                    } else {
                        mapperGroupSet.addAll(Arrays.asList(mapperGroup.target()));
                    }
                }
                ClassName self = ClassName.get((String)packageName, (String)simpleName.toString(), (String[])new String[0]);
                for (String mapperName : mapperSet) {
                    TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(simpleName.toString() + (mapperName.charAt(0) + "").toUpperCase() + mapperName.substring(1).toLowerCase() + "Mapper"));
                    typeSpec.addModifiers(new Modifier[]{Modifier.PUBLIC});
                    if (mapperGroup != null && mapperGroupSet.contains(mapperName)) {
                        MapGroupProcessor.buildMapGroup(mapperGroup, mapperName, typeSpec);
                    }
                    MethodSpec getMapMethod = MapProcessor.buildGetMapMethod(self, mapperName, fields, ignoreDetailMap, modifyDetailMap, renameDetailMap);
                    typeSpec.addMethod(getMapMethod);
                    if (mapperExtra != null && mapperExtraSet.contains(mapperName)) {
                        MethodSpec getMapExtraMethod = MapProcessor.buildGetMapExtraMethod(self, mapperName, fields, ignoreDetailMap, modifyDetailMap, renameDetailMap, mapperExtra, typeElement, typeSpec);
                        typeSpec.addMethod(getMapExtraMethod);
                    }
                    MethodSpec getEntityMethod = EntityProcessor.buildGetEntityMethod(self, mapperName, fields, docDetailMap, ignoreDetailMap, modifyDetailMap, renameDetailMap, typeSpec);
                    typeSpec.addMethod(getEntityMethod);
                    JavaFile.builder((String)packageName, (TypeSpec)typeSpec.build()).build().writeTo(this.filer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private class NameCheckScanner
    extends ElementScanner6<Void, Void> {
        private NameCheckScanner() {
        }

        @Override
        public Void scan(Element e, Void aVoid) {
            return (Void)super.scan(e, aVoid);
        }
    }
}

