/*
 * Decompiled with CFR 0.152.
 */
package cc.eamon.open.mapping.group;

import cc.eamon.open.mapping.ProcessingException;
import cc.eamon.open.mapping.group.Group;
import cc.eamon.open.mapping.group.GroupDetail;
import cc.eamon.open.mapping.mapper.Mapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class GroupProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Group.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            HashMap<String, List> groupDetailMap = new HashMap<String, List>();
            for (Element element : roundEnv.getElementsAnnotatedWith(Group.class)) {
                if (element.getKind() != ElementKind.CLASS) {
                    throw new ProcessingException(element, "Only classes can be annotated with @%s", Mapper.class.getSimpleName());
                }
                Group group = element.getAnnotation(Group.class);
                if (group.value().length == 0) continue;
                for (int i = 0; i < group.value().length; ++i) {
                    List sameGroupList = groupDetailMap.computeIfAbsent(group.value()[i], value -> new ArrayList());
                    GroupDetail groupDetail = new GroupDetail();
                    boolean base = group.base().length > i ? group.base()[i] : group.base().length != 0 && group.base()[group.base().length];
                    groupDetail.setBase(base);
                    boolean list = group.list().length > i ? group.list()[i] : group.list().length != 0 && group.list()[group.list().length];
                    groupDetail.setList(list);
                    String name = group.name().length > i ? group.name()[i] : (group.name().length != 0 ? "" : group.name()[group.name().length]);
                    groupDetail.setName(name);
                    String value2 = group.value().length > i ? group.value()[i] : (group.value().length != 0 ? "" : group.value()[group.value().length]);
                    groupDetail.setValue(value2);
                    groupDetail.setTypeName(TypeName.get((TypeMirror)element.asType()));
                    for (Element element2 : element.getEnclosedElements()) {
                        boolean isMapper = element2.getSimpleName().toString().equals("getMap");
                        if (!isMapper || element2.getKind() != ElementKind.METHOD) continue;
                        groupDetail.setMapper(true);
                        groupDetail.setMapperParameterTypes(((Type.MethodType)element2.asType()).getParameterTypes());
                        break;
                    }
                    sameGroupList.add(groupDetail);
                }
            }
            for (Map.Entry entry : groupDetailMap.entrySet()) {
                if (((List)entry.getValue()).size() == 0) continue;
                String groupValue = ((GroupDetail)((List)entry.getValue()).get(0)).getValue();
                String className = groupValue.replaceAll(".*\\.", "");
                String packageName = groupValue.replaceAll("\\.[^\\.]+$", "");
                TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)className);
                typeSpec.addModifiers(new Modifier[]{Modifier.PUBLIC});
                ClassName string = ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]);
                ClassName object = ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]);
                ClassName map = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
                ClassName linkedHashMap = ClassName.get((String)"java.util", (String)"LinkedHashMap", (String[])new String[0]);
                ParameterizedTypeName typeOfMap = ParameterizedTypeName.get((ClassName)map, (TypeName[])new TypeName[]{string, object});
                String string2 = "getMap";
                MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)string2).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)typeOfMap);
                methodSpec.addStatement("Map<String, Object> resultMap = new $T<>()", new Object[]{linkedHashMap});
                List groupDetails = (List)entry.getValue();
                Collections.sort(groupDetails);
                for (int i = 0; i < groupDetails.size(); ++i) {
                    GroupDetail groupDetail = (GroupDetail)groupDetails.get(i);
                    if (groupDetail.isBase()) {
                        typeSpec.superclass(groupDetail.getTypeName());
                        if (!groupDetail.isMapper()) continue;
                        String objName = "arg" + i;
                        methodSpec.addParameter(TypeName.get((TypeMirror)groupDetail.getMapperParameterTypes().get(0)), objName, new Modifier[0]);
                        String statement = "resultMap.putAll(" + groupDetail.getTypeName().toString().replaceAll(".*\\.", "") + ".getMap(" + objName + "))";
                        methodSpec.addStatement(statement, new Object[0]);
                        continue;
                    }
                    TypeName typeName = groupDetail.getTypeName();
                    if (groupDetail.isList()) {
                        ClassName list = ClassName.get((String)"java.util", (String)"List", (String[])new String[0]);
                        typeName = ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{typeName});
                        if (groupDetail.isMapper()) {
                            ClassName arrayList = ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]);
                            ParameterizedTypeName typeOfParam = ParameterizedTypeName.get((ClassName)list, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)groupDetail.getMapperParameterTypes().get(0))});
                            String objName = "arg" + i;
                            methodSpec.addParameter((TypeName)typeOfParam, objName, new Modifier[0]);
                            methodSpec.addStatement("List<Map<String, Object>> " + groupDetail.getName() + " = new $T<>()", new Object[]{arrayList});
                            methodSpec.addStatement(objName + ".forEach((e)->" + groupDetail.getName() + ".add($T.getMap(e)))", new Object[]{groupDetail.getTypeName()});
                            methodSpec.addStatement("resultMap.put(\"" + groupDetail.getName() + "\", " + groupDetail.getName() + ")", new Object[0]);
                        }
                    } else if (groupDetail.isMapper()) {
                        String objName = "arg" + i;
                        methodSpec.addParameter(TypeName.get((TypeMirror)groupDetail.getMapperParameterTypes().get(0)), objName, new Modifier[0]);
                        methodSpec.addStatement("resultMap.put(\"" + groupDetail.getName() + "\", $T.getMap(" + objName + "))", new Object[]{groupDetail.getTypeName()});
                    }
                    FieldSpec fieldSpec = FieldSpec.builder((TypeName)typeName, (String)groupDetail.getName(), (Modifier[])new Modifier[]{Modifier.PUBLIC}).build();
                    typeSpec.addField(fieldSpec);
                }
                methodSpec.addStatement("return resultMap", new Object[0]);
                typeSpec.addMethod(methodSpec.build());
                JavaFile.builder((String)packageName, (TypeSpec)typeSpec.build()).build().writeTo(this.filer);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

