/*
 * Decompiled with CFR 0.152.
 */
package cc.duduhuo.util.crypto;

import cc.duduhuo.util.digest.Base64;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0003J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcc/duduhuo/util/crypto/DES;", "", "()V", "ALGORITHM", "", "TRANSFORMATION", "decrypt", "input", "key", "", "encrypt", "toDecrypt", "data", "toEncrypt", "digest-util"})
public final class DES {
    private static final String ALGORITHM = "DES";
    private static final String TRANSFORMATION = "DES";
    public static final DES INSTANCE;

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull byte[] key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] byArray = Arrays.copyOf(key, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(key, 16)");
        byte[] bt = INSTANCE.toEncrypt(input, byArray);
        return Base64.encode(bt);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull String key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = key;
        byte[] byArray = input;
        DES dES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        byte[] byArray4 = Arrays.copyOf(byArray3, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"Arrays.copyOf(key.toByteArray(), 16)");
        byte[] bt = dES.toEncrypt(byArray, byArray4);
        return Base64.encode(bt);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull byte[] key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = input;
        DES dES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = Arrays.copyOf(key, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Arrays.copyOf(key, 16)");
        byte[] bt = dES.toEncrypt(byArray2, byArray3);
        return Base64.encode(bt);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull String key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string = input;
        DES dES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = key;
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        byte[] byArray5 = Arrays.copyOf(byArray4, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray5, (String)"Arrays.copyOf(key.toByteArray(), 16)");
        byte[] bt = dES.toEncrypt(byArray2, byArray5);
        return Base64.encode(bt);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull byte[] key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] buf = Base64.decode(input);
        byte[] byArray = Arrays.copyOf(key, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(key, 16)");
        byte[] bt = INSTANCE.toDecrypt(buf, byArray);
        return new String(bt, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull String key) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] buf = Base64.decode(input);
        String string = key;
        byte[] byArray = buf;
        DES dES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        byte[] byArray4 = Arrays.copyOf(byArray3, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"Arrays.copyOf(key.toByteArray(), 16)");
        byte[] bt = dES.toDecrypt(byArray, byArray4);
        return new String(bt, Charsets.UTF_8);
    }

    private final byte[] toEncrypt(byte[] data, byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey sKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, sKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    private final byte[] toDecrypt(byte[] data, byte[] key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey sKey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, sKey);
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    private DES() {
        INSTANCE = this;
    }

    static {
        new DES();
    }
}

