/*
 * Decompiled with CFR 0.152.
 */
package cc.duduhuo.util.crypto;

import cc.duduhuo.util.digest.Base64;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0003J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0003J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/duduhuo/util/crypto/AES;", "", "()V", "ALGORITHM", "", "decrypt", "input", "", "seed", "encrypt", "getRawKey", "toDecrypt", "key", "encrypted", "toEncrypt", "digest-util"})
public final class AES {
    private static final String ALGORITHM = "AES";
    public static final AES INSTANCE;

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] key = INSTANCE.getRawKey(seed);
        byte[] result = INSTANCE.toEncrypt(key, input);
        return Base64.encode(result);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] key = INSTANCE.getRawKey(seed);
        String string = input;
        byte[] byArray = key;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        byte[] result = aES.toEncrypt(byArray, byArray3);
        return Base64.encode(result);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] key = aES.getRawKey(byArray2);
        byte[] result = INSTANCE.toEncrypt(key, input);
        return Base64.encode(result);
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Object object = Charsets.UTF_8;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] key = aES.getRawKey(byArray2);
        object = input;
        byArray2 = key;
        aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray3 = ((String)object).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        byte[] result = aES.toEncrypt(byArray2, byArray4);
        return Base64.encode(result);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull byte[] input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] key = INSTANCE.getRawKey(seed);
        byte[] encrypted = Base64.decode(input);
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] key = INSTANCE.getRawKey(seed);
        byte[] encrypted = Base64.decode(input);
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull byte[] input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] key = aES.getRawKey(byArray2);
        byte[] encrypted = Base64.decode(input);
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] key = aES.getRawKey(byArray2);
        byte[] encrypted = Base64.decode(input);
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    private final byte[] getRawKey(byte[] seed) throws Exception {
        KeyGenerator kGen = KeyGenerator.getInstance(ALGORITHM);
        SecureRandom sr = new SecureRandom(seed);
        kGen.init(128, sr);
        SecretKey key = kGen.generateKey();
        byte[] byArray = key.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.encoded");
        return byArray;
    }

    private final byte[] toEncrypt(byte[] key, byte[] input) throws Exception {
        SecretKeySpec sKeySpec = new SecretKeySpec(key, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, sKeySpec);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(input)");
        return byArray;
    }

    private final byte[] toDecrypt(byte[] key, byte[] encrypted) throws Exception {
        SecretKeySpec sKeySpec = new SecretKeySpec(key, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, sKeySpec);
        byte[] byArray = cipher.doFinal(encrypted);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(encrypted)");
        return byArray;
    }

    private AES() {
        INSTANCE = this;
    }

    static {
        new AES();
    }
}

