package cc.concurrent.config.server.util;

/**
 * User: yanghe.liang
 * Date: 13-10-31
 * Time: 下午10:15
 */
public class FlashRequestContext {

    private String username;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public static ThreadLocal<FlashRequestContext> getContexts() {
        return contexts;
    }

    private static final ThreadLocal<FlashRequestContext> contexts = new ThreadLocal<FlashRequestContext>();

    public static FlashRequestContext getCurrentContext() {
        FlashRequestContext context = contexts.get();
        if (context == null) {
            context = new FlashRequestContext();
            contexts.set(context);
        }
        return context;
    }

    public static void clear() {
        contexts.remove();
    }

}
