package cc.concurrent.config.server.util;

import name.fraser.neil.plaintext.diff_match_patch;

import java.util.LinkedList;

/**
 * User: yanghe.liang
 * Date: 13-10-15
 * Time: 下午10:29
 */
public class DiffUtil {

    public static HtmlView diff(String newContent, String oldContent) {

        HtmlView htmlView = new HtmlView();
        StringBuffer newHtml = new StringBuffer();
        StringBuffer oldHtml = new StringBuffer();

        diff_match_patch dmp = new diff_match_patch();
        LinkedList<diff_match_patch.Diff> diffs = dmp.diff_main(oldContent, newContent);

        for (diff_match_patch.Diff diff : diffs) {
            String text = diff.text.replace("&", "&amp;").replace("<", "&lt;")
                    .replace(">", "&gt;").replace(XmlUtil.crlf, "<br>");
            if (diff.operation == diff_match_patch.Operation.INSERT) {
                newHtml.append("<font style=\"background:#9FDFAF;\">").append(text).append("</font>");
            } else if (diff.operation == diff_match_patch.Operation.EQUAL) {
                newHtml.append(text);
                oldHtml.append(text);
            } else {
                oldHtml.append("<font style=\"background:#FF8484;\">").append(text).append("</font>");
            }
        }

        htmlView.setNewHtml(newHtml.toString());
        htmlView.setOldHtml(oldHtml.toString());
        return htmlView;
    }

}