package cc.concurrent.config.server.service;

import cc.concurrent.config.server.dao.AppDao;
import cc.concurrent.config.server.model.App;
import cc.concurrent.config.server.util.FlashRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-13
 * Time: 下午3:01
 */
@Component
public class AppService {

    @Autowired
    AppDao appDao;

    public void addApp(App app) {
        app.setCreator(FlashRequestContext.getCurrentContext().getUsername());
        app.setCreateTime(new Date());
        appDao.addApp(app);
    }

    public List<App> getApps() {
        return appDao.getApps();
    }

    public App getApp(String appName) {
        return appDao.getApp(appName);
    }

}
