package cc.concurrent.config.server.model;

import com.google.common.xml.XmlEscapers;
import org.springframework.web.util.HtmlUtils;

import java.util.Date;

/**
 * User: yanghe.liang
 * Date: 13-10-13
 * Time: 下午4:15
 */
public abstract class File {

    private String appName;

    private String fileName;

    private int version;

    private String xml;

    private String comment;

    private String creator;

    private Date createTime;

    public File() {
    }

    public File(String appName, String fileName, int version, String xml, String comment, String creator, Date createTime) {
        this.appName = appName;
        this.fileName = fileName;
        this.version = version;
        this.xml = xml;
        this.comment = comment;
        this.creator = creator;
        this.createTime = createTime;
    }

    public String getEscaperXml() {
        return HtmlUtils.htmlEscape(xml);
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getXml() {
        return xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getFullFileName() {
        return fileName + ".xml";
    }
}
