package cc.concurrent.config.server.model;

import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * User: yanghe.liang
 * Date: 13-10-11
 * Time: 下午9:53
 */
public class App {

    @Pattern(regexp = "[_0-9a-zA-Z]{3,20}", message = "appName需要匹配正则表达式[_0-9a-zA-Z]{3,20}")
    private String appName;

    @Size(min = 1, max = 100, message = "description长度必须在1和100之间")
    private String description;

    private String creator;

    private Date createTime;

    public App() {
    }

    public App(String appName, String description, String creator, Date createTime) {
        this.appName = appName;
        this.description = description;
        this.creator = creator;
        this.createTime = createTime;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
