package cc.concurrent.config.server.interceptor;

import cc.concurrent.config.server.model.User;
import cc.concurrent.config.server.util.FlashRequestContext;
import com.mysql.jdbc.StringUtils;
import org.springframework.util.DigestUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * User: yanghe.liang
 * Date: 13-10-20
 * Time: 下午4:11
 */
public class LoginInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Cookie[] cookies = request.getCookies();
        String username = null;
        String mark = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if ("username".equals(cookie.getName())) {
                    username = cookie.getValue();
                } else if ("mark".equals(cookie.getName())) {
                    mark = cookie.getValue();
                }
            }
        }
        if (username != null && username.trim().length() > 0 // 用户名存在
                && DigestUtils.md5DigestAsHex(username.trim().getBytes()).equals(mark)) { // 用户名md5后和mark匹配
            User user = new User();
            user.setUsername(username);
            request.setAttribute("user", user);
            FlashRequestContext.getCurrentContext().setUsername(username);
            return true;
        }
        response.sendRedirect(request.getContextPath() + "/login");
        return false;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}
