package cc.concurrent.config.server.hessian;

import cc.concurrent.config.core.api.FilePublishedApi;
import cc.concurrent.config.core.model.CheckParam;
import cc.concurrent.config.core.model.FilePublished;
import cc.concurrent.config.server.dao.FilePublishedDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

import static com.google.common.base.Preconditions.*;

/**
 * User: yanghe.liang
 * Date: 13-11-1
 * Time: 下午5:28
 */
public class FilePublishedService implements FilePublishedApi {

    @Autowired
    FilePublishedDao filePublishedDao;

    @Override
    public FilePublished download(String appName, String fileName) {
        checkNotNull(appName);
        checkNotNull(fileName);
        FilePublished filePublished = filePublishedDao.getFilePublished(appName, fileName);
        return filePublished;
    }

    @Override
    public List<FilePublished> checkAndDownload(String appName, List<CheckParam> checkParams) {
        checkNotNull(appName);
        checkNotNull(checkParams);
        Map<String, String> map = Maps.newHashMap();
        for (CheckParam checkParam : checkParams) {
            map.put(checkParam.getFileName(), checkParam.getMd5());
        }
        List<FilePublished> r = Lists.newArrayList();
        List<FilePublished> filePublisheds = filePublishedDao.getFilePublisheds(appName);
        for (FilePublished filePublished : filePublisheds) {
            String fileName = filePublished.getFileName();
            String md5 = map.get(fileName);
            if (md5 != null && !md5.equals(filePublished.getMd5())) { // 需要检测，并且不是最新
                r.add(filePublished);
            }
        }
        return r;
    }

}
